package com.zehong.system.mapper;

import com.zehong.system.domain.TComplainDealTransfer;

import java.util.List;

/**
 * 燃气投诉处置-转办记录Mapper接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface TComplainDealTransferMapper 
{
    /**
     * 查询燃气投诉处置-转办记录
     * 
     * @param complainDealTransferId 燃气投诉处置-转办记录ID
     * @return 燃气投诉处置-转办记录
     */
    public TComplainDealTransfer selectTComplainDealTransferById(Long complainDealTransferId);

    /**
     * 查询燃气投诉处置-转办记录列表
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 燃气投诉处置-转办记录集合
     */
    public List<TComplainDealTransfer> selectTComplainDealTransferList(TComplainDealTransfer tComplainDealTransfer);

    /**
     * 查询燃气投诉处置-转办记录列表
     *
     * @param complainDealId 燃气投诉处置Id
     * @return 燃气投诉处置-转办记录集合
     */
    public List<TComplainDealTransfer> queryComplainDealTransferListByComplainDealId(Long complainDealId);



    /**
     * 新增燃气投诉处置-转办记录
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 结果
     */
    public int insertTComplainDealTransfer(TComplainDealTransfer tComplainDealTransfer);

    /**
     * 修改燃气投诉处置-转办记录
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 结果
     */
    public int updateTComplainDealTransfer(TComplainDealTransfer tComplainDealTransfer);

    /**
     * 删除燃气投诉处置-转办记录
     * 
     * @param complainDealTransferId 燃气投诉处置-转办记录ID
     * @return 结果
     */
    public int deleteTComplainDealTransferById(Long complainDealTransferId);

    /**
     * 批量删除燃气投诉处置-转办记录
     * 
     * @param complainDealTransferIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTComplainDealTransferByIds(Long[] complainDealTransferIds);
}
