package com.zehong.system.mapper;

import com.zehong.system.domain.TComplainDealOverSuper;

import java.util.List;

/**
 * 燃气投诉处置-超时督办Mapper接口
 * 
 * @author zehong
 * @date 2024-06-13
 */
public interface TComplainDealOverSuperMapper 
{
    /**
     * 查询燃气投诉处置-超时督办
     * 
     * @param complainDealOverSuperId 燃气投诉处置-超时督办ID
     * @return 燃气投诉处置-超时督办
     */
    public TComplainDealOverSuper selectTComplainDealOverSuperById(Long complainDealOverSuperId);

    /**
     * 查询燃气投诉处置-超时督办列表
     * 
     * @param tComplainDealOverSuper 燃气投诉处置-超时督办
     * @return 燃气投诉处置-超时督办集合
     */
    public List<TComplainDealOverSuper> selectTComplainDealOverSuperList(TComplainDealOverSuper tComplainDealOverSuper);

    /**
     * 新增燃气投诉处置-超时督办
     * 
     * @param tComplainDealOverSuper 燃气投诉处置-超时督办
     * @return 结果
     */
    public int insertTComplainDealOverSuper(TComplainDealOverSuper tComplainDealOverSuper);

    /**
     * 修改燃气投诉处置-超时督办
     * 
     * @param tComplainDealOverSuper 燃气投诉处置-超时督办
     * @return 结果
     */
    public int updateTComplainDealOverSuper(TComplainDealOverSuper tComplainDealOverSuper);

    /**
     * 删除燃气投诉处置-超时督办
     * 
     * @param complainDealOverSuperId 燃气投诉处置-超时督办ID
     * @return 结果
     */
    public int deleteTComplainDealOverSuperById(Long complainDealOverSuperId);

    /**
     * 查询燃气投诉处置-超时督办列表-根据处置id 和 状态
     * @param tComplainDealOverSuper
     * @return
     */
    TComplainDealOverSuper getOverSuperByComplainDealIdAndStatus(TComplainDealOverSuper tComplainDealOverSuper);

    /**
     * 批量删除燃气投诉处置-超时督办
     * 
     * @param complainDealOverSuperIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTComplainDealOverSuperByIds(Long[] complainDealOverSuperIds);
}
