package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TCityLevelRegion;

/**
 * 市级行政区Mapper接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface TCityLevelRegionMapper 
{
    /**
     * 查询市级行政区
     * 
     * @param fId 市级行政区ID
     * @return 市级行政区
     */
    public TCityLevelRegion selectTCityLevelRegionById(Long fId);

    /**
     * 查询市级行政区列表
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 市级行政区集合
     */
    public List<TCityLevelRegion> selectTCityLevelRegionList(TCityLevelRegion tCityLevelRegion);

    /**
     * 新增市级行政区
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 结果
     */
    public int insertTCityLevelRegion(TCityLevelRegion tCityLevelRegion);

    /**
     * 修改市级行政区
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 结果
     */
    public int updateTCityLevelRegion(TCityLevelRegion tCityLevelRegion);

    /**
     * 删除市级行政区
     * 
     * @param fId 市级行政区ID
     * @return 结果
     */
    public int deleteTCityLevelRegionById(Long fId);

    /**
     * 批量删除市级行政区
     * 
     * @param fIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTCityLevelRegionByIds(Long[] fIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTCityLevelRegion(List<TCityLevelRegion> list);
}
