package com.zehong.system.mapper;

import com.zehong.system.domain.AirChargeOperatorStatistics;
import com.zehong.system.domain.AirChargeStationStatistics;
import com.zehong.system.domain.TAirChargeRecord;
import com.zehong.system.domain.vo.AirChargeStatisticsVo;

import java.util.List;

/**
 * 充装记录Mapper接口
 * 
 * @author zehong
 * @date 2023-08-21
 */
public interface TAirChargeRecordMapper 
{
    /**
     * 查询充装记录
     * 
     * @param chargeRecordId 充装记录ID
     * @return 充装记录
     */
    public TAirChargeRecord selectTAirChargeRecordById(Long chargeRecordId);

    /**
     * 查询充装记录列表
     * 
     * @param tAirChargeRecord 充装记录
     * @return 充装记录集合
     */
    public List<TAirChargeRecord> selectTAirChargeRecordList(TAirChargeRecord tAirChargeRecord);

    /**
     * 新增充装记录
     * 
     * @param tAirChargeRecord 充装记录
     * @return 结果
     */
    public int insertTAirChargeRecord(TAirChargeRecord tAirChargeRecord);

    /**
     * 修改充装记录
     * 
     * @param tAirChargeRecord 充装记录
     * @return 结果
     */
    public int updateTAirChargeRecord(TAirChargeRecord tAirChargeRecord);

    /**
     * 删除充装记录
     * 
     * @param chargeRecordId 充装记录ID
     * @return 结果
     */
    public int deleteTAirChargeRecordById(Long chargeRecordId);

    /**
     * 批量删除充装记录
     * 
     * @param chargeRecordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTAirChargeRecordByIds(Long[] chargeRecordIds);

    /**
     * 储配站充装统计
     * @param airChargeStatisticsVo 统计实体
     * @return
     */
    List<AirChargeStationStatistics> airChargeStationStatistics(AirChargeStatisticsVo airChargeStatisticsVo);

    /**
     * 充装人员统计
     * @param airChargeStatisticsVo 统计
     * @return
     */
    List<AirChargeOperatorStatistics> airChargeOperatorStatistics(AirChargeStatisticsVo airChargeStatisticsVo);
}
