package com.zehong.system.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 导入时错误数据存储
 */
@Data
public class TEmployedPeopleInfoErrorDTO extends BaseEntity {

    /** 姓名 */
    @Excel(name = "姓名")
    private String employedPeopleName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 证书编号 */
    @Excel(name = "技能岗位证书编号")
    private String certificateNum;

    /** 受聘企业名称 */
    @Excel(name = "受聘企业名称")
    private String beyondEnterpriseName;

    /** 受聘企业id */
    private String beyondEnterpriseId;

    /** 发证部门 */
    @Excel(name = "发证部门")
    private String registerExaminationType;

    /** 任职岗位：1.主要负责人 2.安全管理人员3.运行维护和抢修人员 */
    @Excel(name = "任职岗位",dictType = "enterprise_type")
    private String peopleOccupation;

    /** 发证日期 */
    @Excel(name = "发证日期")
    @JsonFormat(pattern="yyyy-MM-dd")
    private String issueDate;

    /** 复检日期 */
    @Excel(name = "复检日期")
    private String certificateChange;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 备注 */
    @Excel(name = "错误数据")
    private String importFailReason;

}
