package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 车辆使用记录对象 t_vehicle_use_record
 *
 * @author zehong
 * @date 2023-08-19
 */
public class TVehicleUseRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 车辆使用主键 */
    private Long vehicleUseRecordId;

    /** 储配站主键 */
    @Excel(name = "储配站主键")
    private Long stationId;

    /** 车辆主键 */
    @Excel(name = "车辆主键")
    private Long vehicleId;
    /** 车牌号 */
    @Excel(name = "车牌号")
    private String carNum;

    /**
     * 储配站名称
     */
    private String siteStationName;

    /**
     * 使用人姓名
     */
    private String name;

    /**
     * 车辆编号
     */
    private String vehicleCode;


    /** 车辆使用人 */
    @Excel(name = "车辆使用人")
    private Long vehicleUserId;

    /** 使用时间 */
    @Excel(name = "使用时间")
    private String vehicleUseDate;

    /** 归还时间 */
    @Excel(name = "归还时间")
    private String vehicleReturnDate;

    /**使用时间*/
    private String vehicleUseDateTime;
    /**归还时间*/
    private String vehicleReturnDateTime;

    /** 删除状态：0.否 1.是 */
    @Excel(name = "删除状态：0.否 1.是")
    private String isDel;

    /**
     * 使用状态   0未使用   1使用中
     */
    private String onState;


    public String getOnState() {
        return onState;
    }

    public void setOnState(String onState) {
        this.onState = onState;
    }

    public String getVehicleUseDateTime() {
        return vehicleUseDateTime;
    }

    public void setVehicleUseDateTime(String vehicleUseDateTime) {
        this.vehicleUseDateTime = vehicleUseDateTime;
    }

    public String getVehicleReturnDateTime() {
        return vehicleReturnDateTime;
    }

    public void setVehicleReturnDateTime(String vehicleReturnDateTime) {
        this.vehicleReturnDateTime = vehicleReturnDateTime;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getCarNum() {
        return carNum;
    }

    public void setCarNum(String carNum) {
        this.carNum = carNum;
    }

    public String getSiteStationName() {
        return siteStationName;
    }

    public void setSiteStationName(String siteStationName) {
        this.siteStationName = siteStationName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVehicleCode() {
        return vehicleCode;
    }

    public void setVehicleCode(String vehicleCode) {
        this.vehicleCode = vehicleCode;
    }

    public void setVehicleUseRecordId(Long vehicleUseRecordId)
    {
        this.vehicleUseRecordId = vehicleUseRecordId;
    }

    public Long getVehicleUseRecordId()
    {
        return vehicleUseRecordId;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setVehicleId(Long vehicleId)
    {
        this.vehicleId = vehicleId;
    }

    public Long getVehicleId()
    {
        return vehicleId;
    }
    public void setVehicleUserId(Long vehicleUserId)
    {
        this.vehicleUserId = vehicleUserId;
    }

    public Long getVehicleUserId()
    {
        return vehicleUserId;
    }

    public String getVehicleUseDate() {
        return vehicleUseDate;
    }

    public void setVehicleUseDate(String vehicleUseDate) {
        this.vehicleUseDate = vehicleUseDate;
    }

    public String getVehicleReturnDate() {
        return vehicleReturnDate;
    }

    public void setVehicleReturnDate(String vehicleReturnDate) {
        this.vehicleReturnDate = vehicleReturnDate;
    }

    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return "TVehicleUseRecord{" +
                "vehicleUseRecordId=" + vehicleUseRecordId +
                ", stationId=" + stationId +
                ", vehicleId=" + vehicleId +
                ", carNum='" + carNum + '\'' +
                ", siteStationName='" + siteStationName + '\'' +
                ", name='" + name + '\'' +
                ", vehicleCode='" + vehicleCode + '\'' +
                ", vehicleUserId=" + vehicleUserId +
                ", vehicleUseDate=" + vehicleUseDate +
                ", vehicleReturnDate=" + vehicleReturnDate +
                ", vehicleUseDateTime='" + vehicleUseDateTime + '\'' +
                ", vehicleReturnDateTime='" + vehicleReturnDateTime + '\'' +
                ", isDel='" + isDel + '\'' +
                ", onState='" + onState + '\'' +
                '}';
    }
}
