package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气督办对象 t_supervisor_info
 * 
 * @author zehong
 * @date 2022-03-31
 */
public class TSupervisorInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 督办id */
    private Long supervisorId;

    /** 巡检任务id */
    @Excel(name = "巡检任务id")
    private Long workId;

    /** 督办内容 */
    @Excel(name = "督办内容")
    private String supervisorContent;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setSupervisorId(Long supervisorId) 
    {
        this.supervisorId = supervisorId;
    }

    public Long getSupervisorId() 
    {
        return supervisorId;
    }
    public void setWorkId(Long workId) 
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setSupervisorContent(String supervisorContent) 
    {
        this.supervisorContent = supervisorContent;
    }

    public String getSupervisorContent() 
    {
        return supervisorContent;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("supervisorId", getSupervisorId())
            .append("workId", getWorkId())
            .append("supervisorContent", getSupervisorContent())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
