package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 供需平衡-企业每日填报对象 t_sup_bal_usg_day
 * 
 * @author zehong
 * @date 2024-06-25
 */
public class TSupBalUsgDay extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fRepUsgDayId;

    /** 企业uuid */
    private String fCompanyInfoId;

    @Excel(name = "企业名称")
    private String enterpriseName;

    /** 天然气城镇居民用量（m3） */
    @Excel(name = "天然气城镇居民用量(万立方米)")
    private Long fUrbanGasUsage;

    /** 天然气农村气代煤居民用量（m3） */
    @Excel(name = "天然气农村气代煤居民用量(万立方米)")
    private Long fRuralReplaceResidentsGasUsage;

    /** 天然气农村非气代煤居民用量（m3） */
    @Excel(name = "天然气农村非气代煤居民用量(万立方米)")
    private Long fNoRuralReplaceResidentsGasUsage;

    /** 天然气工业用量（m3） */
    @Excel(name = "天然气工业用量(万立方米)")
    private Long fIndustrialGasUsage;

    /** 天然气商业用量（m3） */
    @Excel(name = "天然气商业用量(万立方米)")
    private Long fCommercialGasUsage;

    /** 天然气公福用量（m3） */
    @Excel(name = "天然气公福用量(万立方米)")
    private Long fPublicGasUsage;

    /** 天然气城市集中供热锅炉用量（m3） */
    @Excel(name = "天然气城市集中供热锅炉用量(万立方米)")
    private Long fCityHeatingGasUasge;

    /** 天然气汽车用户用量（m3） */
    @Excel(name = "天然气汽车用户用量(万立方米)")
    private Long fCarGasUsage;

    /** 出售给其他燃气企业的天然气量（m3） */
    @Excel(name = "出售给其他燃气企业的天然气量(万立方米)")
    private Long fSoldGasVolume;

    /** 天然气总凄凉（m3） */
    @Excel(name = "天然气总气量万(万立方米)")
    private Long fGasUsage;

    /** 液化石油气城镇居民用量 */
    @Excel(name = "液化石油气城镇居民用量(万立方米)")
    private Long fUrbanLpgUsage;

    /** 液化石油气农村居民用量（吨） */
    @Excel(name = "液化石油气农村居民用量(万立方米)")
    private Long fRuralLpgUsage;

    /** 液化石油气工业用量(吨) */
    @Excel(name = "液化石油气工业用量(吨)")
    private Long fIndustrialLpgUsage;

    /** 液化石油气商业用量(吨) */
    @Excel(name = "液化石油气商业用量(吨)")
    private Long fCommercialLpgUsage;

    /** 液化石油气公福用量(吨) */
    @Excel(name = "液化石油气公福用量(吨)")
    private Long fPublicLpgUsage;

    /** 液化石油气汽车用户用量(吨) */
    @Excel(name = "液化石油气汽车用户用量(吨)")
    private Long fCarLpgUsage;

    /** 出售或调拨给其他燃气企业液化石油气量(吨) */
    @Excel(name = "出售或调拨给其他燃气企业液化石油气量(吨)")
    private Long fSoldLpgVolume;

    /** 液化石油气总量(吨) */
    @Excel(name = "液化石油气总量(吨)")
    private Long fLpgUsage;

    /** 记录时间，日，格式:2023-09-01 */
    private String fReportRecord;

    @Excel(name = "上报状态",readConverterExp = "0=未上报,1=已上报")
    private String fReportStatus;

    /** 上报时间，日，格式:2023-09-01 */
    @Excel(name = "上报时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private String fReportTime;

    /** 创建时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "创建时间")
    private String fCreateTime;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "最后修改时间")
    private String fUpdateTime;

    private String beginRepDate;

    private String endRepDate;

    /** 日历日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日历日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCalendarDate;

    /** 政府端上报状态0-未上报，1-已上报，默认0 */
    @Excel(name = "上报省厅状态",readConverterExp = " 0=未上报,1=已上报")
    private String fGovUploadStatus;

    /** 政府端上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上报省厅时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date fGovUploadTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginCurrentMonthDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endCurrentMonthDate;

    public void setfRepUsgDayId(Long fRepUsgDayId) 
    {
        this.fRepUsgDayId = fRepUsgDayId;
    }

    public Long getfRepUsgDayId() 
    {
        return fRepUsgDayId;
    }
    public void setfCompanyInfoId(String fCompanyInfoId) 
    {
        this.fCompanyInfoId = fCompanyInfoId;
    }

    public String getfCompanyInfoId() 
    {
        return fCompanyInfoId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public void setfUrbanGasUsage(Long fUrbanGasUsage)
    {
        this.fUrbanGasUsage = fUrbanGasUsage;
    }

    public Long getfUrbanGasUsage() 
    {
        return fUrbanGasUsage;
    }
    public void setfRuralReplaceResidentsGasUsage(Long fRuralReplaceResidentsGasUsage) 
    {
        this.fRuralReplaceResidentsGasUsage = fRuralReplaceResidentsGasUsage;
    }

    public Long getfRuralReplaceResidentsGasUsage() 
    {
        return fRuralReplaceResidentsGasUsage;
    }
    public void setfNoRuralReplaceResidentsGasUsage(Long fNoRuralReplaceResidentsGasUsage) 
    {
        this.fNoRuralReplaceResidentsGasUsage = fNoRuralReplaceResidentsGasUsage;
    }

    public Long getfNoRuralReplaceResidentsGasUsage() 
    {
        return fNoRuralReplaceResidentsGasUsage;
    }
    public void setfIndustrialGasUsage(Long fIndustrialGasUsage) 
    {
        this.fIndustrialGasUsage = fIndustrialGasUsage;
    }

    public Long getfIndustrialGasUsage() 
    {
        return fIndustrialGasUsage;
    }
    public void setfCommercialGasUsage(Long fCommercialGasUsage) 
    {
        this.fCommercialGasUsage = fCommercialGasUsage;
    }

    public Long getfCommercialGasUsage() 
    {
        return fCommercialGasUsage;
    }
    public void setfPublicGasUsage(Long fPublicGasUsage) 
    {
        this.fPublicGasUsage = fPublicGasUsage;
    }

    public Long getfPublicGasUsage() 
    {
        return fPublicGasUsage;
    }
    public void setfCityHeatingGasUasge(Long fCityHeatingGasUasge) 
    {
        this.fCityHeatingGasUasge = fCityHeatingGasUasge;
    }

    public Long getfCityHeatingGasUasge() 
    {
        return fCityHeatingGasUasge;
    }
    public void setfCarGasUsage(Long fCarGasUsage) 
    {
        this.fCarGasUsage = fCarGasUsage;
    }

    public Long getfCarGasUsage() 
    {
        return fCarGasUsage;
    }
    public void setfSoldGasVolume(Long fSoldGasVolume) 
    {
        this.fSoldGasVolume = fSoldGasVolume;
    }

    public Long getfSoldGasVolume() 
    {
        return fSoldGasVolume;
    }
    public void setfGasUsage(Long fGasUsage) 
    {
        this.fGasUsage = fGasUsage;
    }

    public Long getfGasUsage() 
    {
        return fGasUsage;
    }
    public void setfUrbanLpgUsage(Long fUrbanLpgUsage) 
    {
        this.fUrbanLpgUsage = fUrbanLpgUsage;
    }

    public Long getfUrbanLpgUsage() 
    {
        return fUrbanLpgUsage;
    }
    public void setfRuralLpgUsage(Long fRuralLpgUsage) 
    {
        this.fRuralLpgUsage = fRuralLpgUsage;
    }

    public Long getfRuralLpgUsage() 
    {
        return fRuralLpgUsage;
    }
    public void setfIndustrialLpgUsage(Long fIndustrialLpgUsage) 
    {
        this.fIndustrialLpgUsage = fIndustrialLpgUsage;
    }

    public Long getfIndustrialLpgUsage() 
    {
        return fIndustrialLpgUsage;
    }
    public void setfCommercialLpgUsage(Long fCommercialLpgUsage) 
    {
        this.fCommercialLpgUsage = fCommercialLpgUsage;
    }

    public Long getfCommercialLpgUsage() 
    {
        return fCommercialLpgUsage;
    }
    public void setfPublicLpgUsage(Long fPublicLpgUsage) 
    {
        this.fPublicLpgUsage = fPublicLpgUsage;
    }

    public Long getfPublicLpgUsage() 
    {
        return fPublicLpgUsage;
    }
    public void setfCarLpgUsage(Long fCarLpgUsage) 
    {
        this.fCarLpgUsage = fCarLpgUsage;
    }

    public Long getfCarLpgUsage() 
    {
        return fCarLpgUsage;
    }
    public void setfSoldLpgVolume(Long fSoldLpgVolume) 
    {
        this.fSoldLpgVolume = fSoldLpgVolume;
    }

    public Long getfSoldLpgVolume() 
    {
        return fSoldLpgVolume;
    }
    public void setfLpgUsage(Long fLpgUsage) 
    {
        this.fLpgUsage = fLpgUsage;
    }

    public Long getfLpgUsage() 
    {
        return fLpgUsage;
    }
    public void setfReportRecord(String fReportRecord) 
    {
        this.fReportRecord = fReportRecord;
    }

    public String getfReportRecord() 
    {
        return fReportRecord;
    }
    public void setfReportTime(String fReportTime) 
    {
        this.fReportTime = fReportTime;
    }

    public String getfReportTime() 
    {
        return fReportTime;
    }

    public String getfReportStatus() {
        return fReportStatus;
    }

    public void setfReportStatus(String fReportStatus) {
        this.fReportStatus = fReportStatus;
    }

    public void setfCreateTime(String fCreateTime)
    {
        this.fCreateTime = fCreateTime;
    }

    public String getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }

    public String getBeginRepDate() {
        return beginRepDate;
    }

    public void setBeginRepDate(String beginRepDate) {
        this.beginRepDate = beginRepDate;
    }

    public String getEndRepDate() {
        return endRepDate;
    }

    public void setEndRepDate(String endRepDate) {
        this.endRepDate = endRepDate;
    }

    public Date getfCalendarDate() {
        return fCalendarDate;
    }

    public void setfCalendarDate(Date fCalendarDate) {
        this.fCalendarDate = fCalendarDate;
    }

    public String getfGovUploadStatus() {
        return fGovUploadStatus;
    }

    public void setfGovUploadStatus(String fGovUploadStatus) {
        this.fGovUploadStatus = fGovUploadStatus;
    }

    public Date getfGovUploadTime() {
        return fGovUploadTime;
    }

    public void setfGovUploadTime(Date fGovUploadTime) {
        this.fGovUploadTime = fGovUploadTime;
    }

    public Date getBeginCurrentMonthDate() {
        return beginCurrentMonthDate;
    }

    public void setBeginCurrentMonthDate(Date beginCurrentMonthDate) {
        this.beginCurrentMonthDate = beginCurrentMonthDate;
    }

    public Date getEndCurrentMonthDate() {
        return endCurrentMonthDate;
    }

    public void setEndCurrentMonthDate(Date endCurrentMonthDate) {
        this.endCurrentMonthDate = endCurrentMonthDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fRepUsgDayId", getfRepUsgDayId())
            .append("fCompanyInfoId", getfCompanyInfoId())
            .append("fUrbanGasUsage", getfUrbanGasUsage())
            .append("fRuralReplaceResidentsGasUsage", getfRuralReplaceResidentsGasUsage())
            .append("fNoRuralReplaceResidentsGasUsage", getfNoRuralReplaceResidentsGasUsage())
            .append("fIndustrialGasUsage", getfIndustrialGasUsage())
            .append("fCommercialGasUsage", getfCommercialGasUsage())
            .append("fPublicGasUsage", getfPublicGasUsage())
            .append("fCityHeatingGasUasge", getfCityHeatingGasUasge())
            .append("fCarGasUsage", getfCarGasUsage())
            .append("fSoldGasVolume", getfSoldGasVolume())
            .append("fGasUsage", getfGasUsage())
            .append("fUrbanLpgUsage", getfUrbanLpgUsage())
            .append("fRuralLpgUsage", getfRuralLpgUsage())
            .append("fIndustrialLpgUsage", getfIndustrialLpgUsage())
            .append("fCommercialLpgUsage", getfCommercialLpgUsage())
            .append("fPublicLpgUsage", getfPublicLpgUsage())
            .append("fCarLpgUsage", getfCarLpgUsage())
            .append("fSoldLpgVolume", getfSoldLpgVolume())
            .append("fLpgUsage", getfLpgUsage())
            .append("fReportRecord", getfReportRecord())
            .append("fReportTime", getfReportTime())
            .append("fCreateTime", getfCreateTime())
            .append("fUpdateTime", getfUpdateTime())
            .toString();
    }
}
