package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 供需平衡-停气监管-停气进度操作历史记录对象 t_sup_bal_stop_sup_opr_press_log
 * 
 * @author zehong
 * @date 2024-07-16
 */
public class TSupBalStopSupOprPressLog extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fOprPressLogId;

    /** 关联-供需平衡-停气监管-表id */
    @Excel(name = "关联-供需平衡-停气监管-表id")
    private Long fGasStopId;

    /** 停气进度，0-未停气，1-已停气，2-已恢复 */
    @Excel(name = "停气进度，0-未停气，1-已停气，2-已恢复")
    private String fStopProgress;

    /** 操作停气进度时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "操作停气进度时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fOprDate;

    public void setfOprPressLogId(Long fOprPressLogId) 
    {
        this.fOprPressLogId = fOprPressLogId;
    }

    public Long getfOprPressLogId() 
    {
        return fOprPressLogId;
    }
    public void setfGasStopId(Long fGasStopId) 
    {
        this.fGasStopId = fGasStopId;
    }

    public Long getfGasStopId() 
    {
        return fGasStopId;
    }
    public void setfStopProgress(String fStopProgress) 
    {
        this.fStopProgress = fStopProgress;
    }

    public String getfStopProgress() 
    {
        return fStopProgress;
    }
    public void setfOprDate(Date fOprDate) 
    {
        this.fOprDate = fOprDate;
    }

    public Date getfOprDate() 
    {
        return fOprDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fOprPressLogId", getfOprPressLogId())
            .append("fGasStopId", getfGasStopId())
            .append("fStopProgress", getfStopProgress())
            .append("fOprDate", getfOprDate())
            .toString();
    }
}
