package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 供需平衡-气量监管对象 t_sup_bal_gas_sup
 * 
 * @author zehong
 * @date 2024-06-15
 */
public class TSupBalGasSup extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fGasSupId;

    /** 企业uuid */
    private String fCompanyInfoId;

    @Excel(name = "企业名称")
    private String enterpriseName;

    /** 计划量 */
    @Excel(name = "计划量")
    private Long fPlanQuan;

    /** 批复量 */
    @Excel(name = "批复量")
    private Long fApprQuan;

    /** 供气量 */
    @Excel(name = "供气量")
    private Long fSupGasVol;

    /** 存储量 */
    @Excel(name = "存储量")
    private Long fStorageVol;

    /** 监管气量日期 */
    @Excel(name = "监管气量日期", dateFormat = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date fSupDate;

    /** 上报状态 0-未上报，1-已上报 */
    @Excel(name = "上报状态",readConverterExp = "0=未上报,1=已上报")
    private String fRepStatus;

    /** 上报日期 */
    @Excel(name = "上报日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date fRepDate;


    /** 日历日期*/
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date calendarDate;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginRepDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endRepDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginCurrentMonthDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endCurrentMonthDate;

    /** 政府端上报状态 */
    @Excel(name = "上报省厅状态",readConverterExp = "0=未上报,1=已上报")
    private String fGovUploadStatus;

    /** 政府端上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上报省厅日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date fGovUploadTime;

    public void setfGasSupId(Long fGasSupId) 
    {
        this.fGasSupId = fGasSupId;
    }

    public Long getfGasSupId() 
    {
        return fGasSupId;
    }
    public void setfCompanyInfoId(String fCompanyInfoId) 
    {
        this.fCompanyInfoId = fCompanyInfoId;
    }

    public String getfCompanyInfoId() 
    {
        return fCompanyInfoId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public void setfPlanQuan(Long fPlanQuan)
    {
        this.fPlanQuan = fPlanQuan;
    }

    public Long getfPlanQuan() 
    {
        return fPlanQuan;
    }
    public void setfApprQuan(Long fApprQuan) 
    {
        this.fApprQuan = fApprQuan;
    }

    public Long getfApprQuan() 
    {
        return fApprQuan;
    }
    public void setfSupGasVol(Long fSupGasVol) 
    {
        this.fSupGasVol = fSupGasVol;
    }

    public Long getfSupGasVol() 
    {
        return fSupGasVol;
    }
    public void setfStorageVol(Long fStorageVol) 
    {
        this.fStorageVol = fStorageVol;
    }

    public Long getfStorageVol() 
    {
        return fStorageVol;
    }
    public void setfSupDate(Date fSupDate)
    {
        this.fSupDate = fSupDate;
    }

    public Date getfSupDate()
    {
        return fSupDate;
    }
    public void setfRepStatus(String fRepStatus) 
    {
        this.fRepStatus = fRepStatus;
    }

    public String getfRepStatus() 
    {
        return fRepStatus;
    }
    public void setfRepDate(Date fRepDate) 
    {
        this.fRepDate = fRepDate;
    }

    public Date getfRepDate() 
    {
        return fRepDate;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public Date getBeginRepDate() {
        return beginRepDate;
    }

    public void setBeginRepDate(Date beginRepDate) {
        this.beginRepDate = beginRepDate;
    }

    public Date getEndRepDate() {
        return endRepDate;
    }

    public void setEndRepDate(Date endRepDate) {
        this.endRepDate = endRepDate;
    }

    public Date getCalendarDate() {
        return calendarDate;
    }

    public void setCalendarDate(Date calendarDate) {
        this.calendarDate = calendarDate;
    }

    public Date getBeginCurrentMonthDate() {
        return beginCurrentMonthDate;
    }

    public void setBeginCurrentMonthDate(Date beginCurrentMonthDate) {
        this.beginCurrentMonthDate = beginCurrentMonthDate;
    }

    public Date getEndCurrentMonthDate() {
        return endCurrentMonthDate;
    }

    public void setEndCurrentMonthDate(Date endCurrentMonthDate) {
        this.endCurrentMonthDate = endCurrentMonthDate;
    }

    public String getfGovUploadStatus() {
        return fGovUploadStatus;
    }

    public void setfGovUploadStatus(String fGovUploadStatus) {
        this.fGovUploadStatus = fGovUploadStatus;
    }

    public Date getfGovUploadTime() {
        return fGovUploadTime;
    }

    public void setfGovUploadTime(Date fGovUploadTime) {
        this.fGovUploadTime = fGovUploadTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fGasSupId", getfGasSupId())
            .append("fCompanyInfoId", getfCompanyInfoId())
            .append("fPlanQuan", getfPlanQuan())
            .append("fApprQuan", getfApprQuan())
            .append("fSupGasVol", getfSupGasVol())
            .append("fStorageVol", getfStorageVol())
            .append("fSupDate", getfSupDate())
            .append("fRepStatus", getfRepStatus())
            .append("fRepDate", getfRepDate())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
