package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 序列号对象 t_serial_number_info
 *
 * @author zehong
 * @date 2024-06-13
 */
public class TSerialNumberInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 序列号主键 */
    private Long numberId;

    /** 表类型 */
    @Excel(name = "表类型")
    private String tableType;

    /** 列名 */
    @Excel(name = "列名")
    private String columnName;

    /** 最大值 */
    @Excel(name = "最大值")
    private Long maxNum;

    /** 序号长度 */
    @Excel(name = "序号长度")
    private Long numLength;

    /** 版本号 */
    @Excel(name = "版本号")
    private Long version;

    /** 删除状态：0.否 1.是 */
    @Excel(name = "删除状态：0.否 1.是")
    private String isDel;

    public void setNumberId(Long numberId)
    {
        this.numberId = numberId;
    }

    public Long getNumberId()
    {
        return numberId;
    }
    public void setTableType(String tableType)
    {
        this.tableType = tableType;
    }

    public String getTableType()
    {
        return tableType;
    }
    public void setColumnName(String columnName)
    {
        this.columnName = columnName;
    }

    public String getColumnName()
    {
        return columnName;
    }
    public void setMaxNum(Long maxNum)
    {
        this.maxNum = maxNum;
    }

    public Long getMaxNum()
    {
        return maxNum;
    }
    public void setNumLength(Long numLength)
    {
        this.numLength = numLength;
    }

    public Long getNumLength()
    {
        return numLength;
    }
    public void setVersion(Long version)
    {
        this.version = version;
    }

    public Long getVersion()
    {
        return version;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("numberId", getNumberId())
                .append("tableType", getTableType())
                .append("columnName", getColumnName())
                .append("maxNum", getMaxNum())
                .append("numLength", getNumLength())
                .append("version", getVersion())
                .append("updateTime", getUpdateTime())
                .append("updateBy", getUpdateBy())
                .append("isDel", getIsDel())
                .append("remark", getRemark())
                .toString();
    }
}