package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 安全宣传对象 t_security_disseminate
 * 
 * @author zehong
 * @date 2024-04-22
 */
public class TSecurityDisseminate extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long securityId;

    /** 宣传类型 */
    @Excel(name = "宣传类型")
    private String securityType;

    /** 标题 */
    @Excel(name = "标题")
    private String title;

    /** 内容 */
    @Excel(name = "内容")
    private String content;

    /** 文件 */
    @Excel(name = "文件")
    private String filePath;

    /** 发表人 */
    @Excel(name = "发表人")
    private String people;

    public void setSecurityId(Long securityId) 
    {
        this.securityId = securityId;
    }

    public Long getSecurityId() 
    {
        return securityId;
    }
    public void setSecurityType(String securityType) 
    {
        this.securityType = securityType;
    }

    public String getSecurityType() 
    {
        return securityType;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setFilePath(String filePath) 
    {
        this.filePath = filePath;
    }

    public String getFilePath() 
    {
        return filePath;
    }
    public void setPeople(String people) 
    {
        this.people = people;
    }

    public String getPeople() 
    {
        return people;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("securityId", getSecurityId())
            .append("securityType", getSecurityType())
            .append("title", getTitle())
            .append("content", getContent())
            .append("filePath", getFilePath())
            .append("people", getPeople())
            .append("createTime", getCreateTime())
            .toString();
    }
}
