package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 行业专家库-专家申报对象 t_pro_app_infor
 * 
 * @author zehong
 * @date 2024-05-06
 */
public class TProAppInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fProAppInforId;

    /** 数据限定 */
    @Excel(name = "数据限定")
    private String fDeptCode;

    /** 数据来源-G政府：E企业 */
    @Excel(name = "数据来源",dictType = "t_special_data_source")
    private String fSource;

    /** 人员编码 */
    @Excel(name = "人员编码")
    private String fCode;

    /** 专家姓名 */
    @Excel(name = "专家姓名")
    private String fName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String fIdNo;

    /** 性别：1-男性，2-女性 */
    @Excel(name = "性别",dictType = "t_sex")
    private String fSex;

    /** 出生日期 */
    @Excel(name = "出生日期",dateFormat = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date fBirthday;

    /** 邮箱 */
    @Excel(name = "邮箱")
    private String fEmail;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String fPhone;

    /** 文化程度 */
    @Excel(name = "文化程度")
    private String fEducation;

    /** 毕业院校 */
    @Excel(name = "毕业院校")
    private String fGraduationSchool;

    /** 所属专业 */
    @Excel(name = "所属专业")
    private String fMajor;

    /** 毕业时间 */
    @Excel(name = "毕业时间")
    private String fGraduationTime;

    /** 工作单位编码 */
    @Excel(name = "工作单位编码")
    private String fEntUuid;

    /** 工作单位名称 */
    @Excel(name = "工作单位名称")
    private String fWorkUnit;

    /** 参加工作时间 */
    @Excel(name = "参加工作时间",dateFormat = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date fWorkTime;

    /** 所在部门 */
    @Excel(name = "所在部门")
    private String fDepartment;

    /** 职务 */
    @Excel(name = "职务")
    private String fDuties;

    /** 专业技术职称 */
    @Excel(name = "专业技术职称")
    private String fMajorTitle;

    /** 现从事专业 */
    @Excel(name = "现从事专业")
    private String fMajorNow;

    /** 从事专业工作年限 */
    @Excel(name = "从事专业工作年限")
    private Long fMajorLife;

    /** 从事行业燃气种类 可以是多个，逗号分割

            03-0100-0101：管道燃气

            03-0100-0102：液化天然气（LNG）

            03-0100-0103：压缩天然气(CNG)

            03-0200：液化石油气(LPG)

            03-0300：人工煤气

            03-0400：液化石油气混空气

            03-0500：沼气

            03-0600：氢气 */
    @Excel(name = "从事行业燃气种类",dictType = "t_gas_type")
    private String fGasType;

    /** 擅长工作领域，可以是多个，逗号分割 */
    @Excel(name = "擅长工作领域")
    private String fGoodArea;

    /** 相关学习工作经历及工作业绩 */
    @Excel(name = "相关学习工作经历及工作业绩")
    private String fLearningWorkExperience;

    /** 所在地区 */
    @Excel(name = "所在地区")
    private String fArea;

    /** 删除标记，0-可用，1-已删除 */
    @Excel(name = "删除标记",readConverterExp = "0=可用,1=已删除")
    private Long fDeleteFlag;

    /** 市局燃气主管部门意见 */
    @Excel(name = "市局燃气主管部门意见")
    private String fCRecord;

    /** 省级燃气主管部门意见 */
    @Excel(name = "省级燃气主管部门意见")
    private String fPRecord;

    /** 照片 */
    @Excel(name = "照片")
    private String fPicture;

    /** 最后修改时间 */
    @Excel(name = "最后修改时间")
    private String fUpdateTime;

    /** 是否省级专家 1 是，0 不是 */
    @Excel(name = "是否省级专家",dictType = "t_province_mark")
    private String fThisProvinceFlag;

    /** 是否有效：0 有效，1 无效 */
    @Excel(name = "是否有效",dictType = "t_valid_type")
    private Long fValidType;

    /** 申报状态：1 已申报，2 未申报 */
    @Excel(name = "申报状态",dictType = "t_expert_rep_status")
    private Long fRepStatus;

    /** 申报时间 */
    @Excel(name = "申报时间")
    private String fRepDate;

    public void setfProAppInforId(Long fProAppInforId) 
    {
        this.fProAppInforId = fProAppInforId;
    }

    public Long getfProAppInforId() 
    {
        return fProAppInforId;
    }
    public void setfDeptCode(String fDeptCode) 
    {
        this.fDeptCode = fDeptCode;
    }

    public String getfDeptCode() 
    {
        return fDeptCode;
    }
    public void setfSource(String fSource) 
    {
        this.fSource = fSource;
    }

    public String getfSource() 
    {
        return fSource;
    }
    public void setfCode(String fCode) 
    {
        this.fCode = fCode;
    }

    public String getfCode() 
    {
        return fCode;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfIdNo(String fIdNo) 
    {
        this.fIdNo = fIdNo;
    }

    public String getfIdNo() 
    {
        return fIdNo;
    }
    public void setfSex(String fSex) 
    {
        this.fSex = fSex;
    }

    public String getfSex() 
    {
        return fSex;
    }
    public void setfBirthday(Date fBirthday)
    {
        this.fBirthday = fBirthday;
    }

    public Date getfBirthday()
    {
        return fBirthday;
    }
    public void setfEmail(String fEmail) 
    {
        this.fEmail = fEmail;
    }

    public String getfEmail() 
    {
        return fEmail;
    }
    public void setfPhone(String fPhone) 
    {
        this.fPhone = fPhone;
    }

    public String getfPhone() 
    {
        return fPhone;
    }
    public void setfEducation(String fEducation) 
    {
        this.fEducation = fEducation;
    }

    public String getfEducation() 
    {
        return fEducation;
    }
    public void setfGraduationSchool(String fGraduationSchool) 
    {
        this.fGraduationSchool = fGraduationSchool;
    }

    public String getfGraduationSchool() 
    {
        return fGraduationSchool;
    }
    public void setfMajor(String fMajor) 
    {
        this.fMajor = fMajor;
    }

    public String getfMajor() 
    {
        return fMajor;
    }
    public void setfGraduationTime(String fGraduationTime) 
    {
        this.fGraduationTime = fGraduationTime;
    }

    public String getfGraduationTime() 
    {
        return fGraduationTime;
    }
    public void setfEntUuid(String fEntUuid) 
    {
        this.fEntUuid = fEntUuid;
    }

    public String getfEntUuid() 
    {
        return fEntUuid;
    }
    public void setfWorkUnit(String fWorkUnit) 
    {
        this.fWorkUnit = fWorkUnit;
    }

    public String getfWorkUnit() 
    {
        return fWorkUnit;
    }
    public void setfWorkTime(Date fWorkTime)
    {
        this.fWorkTime = fWorkTime;
    }

    public Date getfWorkTime()
    {
        return fWorkTime;
    }
    public void setfDepartment(String fDepartment) 
    {
        this.fDepartment = fDepartment;
    }

    public String getfDepartment() 
    {
        return fDepartment;
    }
    public void setfDuties(String fDuties) 
    {
        this.fDuties = fDuties;
    }

    public String getfDuties() 
    {
        return fDuties;
    }
    public void setfMajorTitle(String fMajorTitle) 
    {
        this.fMajorTitle = fMajorTitle;
    }

    public String getfMajorTitle() 
    {
        return fMajorTitle;
    }
    public void setfMajorNow(String fMajorNow) 
    {
        this.fMajorNow = fMajorNow;
    }

    public String getfMajorNow() 
    {
        return fMajorNow;
    }
    public void setfMajorLife(Long fMajorLife) 
    {
        this.fMajorLife = fMajorLife;
    }

    public Long getfMajorLife() 
    {
        return fMajorLife;
    }
    public void setfGasType(String fGasType) 
    {
        this.fGasType = fGasType;
    }

    public String getfGasType() 
    {
        return fGasType;
    }
    public void setfGoodArea(String fGoodArea) 
    {
        this.fGoodArea = fGoodArea;
    }

    public String getfGoodArea() 
    {
        return fGoodArea;
    }
    public void setfLearningWorkExperience(String fLearningWorkExperience) 
    {
        this.fLearningWorkExperience = fLearningWorkExperience;
    }

    public String getfLearningWorkExperience() 
    {
        return fLearningWorkExperience;
    }
    public void setfArea(String fArea) 
    {
        this.fArea = fArea;
    }

    public String getfArea() 
    {
        return fArea;
    }
    public void setfDeleteFlag(Long fDeleteFlag) 
    {
        this.fDeleteFlag = fDeleteFlag;
    }

    public Long getfDeleteFlag() 
    {
        return fDeleteFlag;
    }
    public void setfCRecord(String fCRecord) 
    {
        this.fCRecord = fCRecord;
    }

    public String getfCRecord() 
    {
        return fCRecord;
    }
    public void setfPRecord(String fPRecord) 
    {
        this.fPRecord = fPRecord;
    }

    public String getfPRecord() 
    {
        return fPRecord;
    }
    public void setfPicture(String fPicture) 
    {
        this.fPicture = fPicture;
    }

    public String getfPicture() 
    {
        return fPicture;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfThisProvinceFlag(String fThisProvinceFlag) 
    {
        this.fThisProvinceFlag = fThisProvinceFlag;
    }

    public String getfThisProvinceFlag() 
    {
        return fThisProvinceFlag;
    }
    public void setfValidType(Long fValidType) 
    {
        this.fValidType = fValidType;
    }

    public Long getfValidType() 
    {
        return fValidType;
    }
    public void setfRepStatus(Long fRepStatus) 
    {
        this.fRepStatus = fRepStatus;
    }

    public Long getfRepStatus() 
    {
        return fRepStatus;
    }
    public void setfRepDate(String fRepDate) 
    {
        this.fRepDate = fRepDate;
    }

    public String getfRepDate() 
    {
        return fRepDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fProAppInforId", getfProAppInforId())
            .append("fDeptCode", getfDeptCode())
            .append("fSource", getfSource())
            .append("fCode", getfCode())
            .append("fName", getfName())
            .append("fIdNo", getfIdNo())
            .append("fSex", getfSex())
            .append("fBirthday", getfBirthday())
            .append("fEmail", getfEmail())
            .append("fPhone", getfPhone())
            .append("fEducation", getfEducation())
            .append("fGraduationSchool", getfGraduationSchool())
            .append("fMajor", getfMajor())
            .append("fGraduationTime", getfGraduationTime())
            .append("fEntUuid", getfEntUuid())
            .append("fWorkUnit", getfWorkUnit())
            .append("fWorkTime", getfWorkTime())
            .append("fDepartment", getfDepartment())
            .append("fDuties", getfDuties())
            .append("fMajorTitle", getfMajorTitle())
            .append("fMajorNow", getfMajorNow())
            .append("fMajorLife", getfMajorLife())
            .append("fGasType", getfGasType())
            .append("fGoodArea", getfGoodArea())
            .append("fLearningWorkExperience", getfLearningWorkExperience())
            .append("fArea", getfArea())
            .append("fDeleteFlag", getfDeleteFlag())
            .append("fCRecord", getfCRecord())
            .append("fPRecord", getfPRecord())
            .append("fPicture", getfPicture())
            .append("fUpdateTime", getfUpdateTime())
            .append("fThisProvinceFlag", getfThisProvinceFlag())
            .append("fValidType", getfValidType())
            .append("fRepStatus", getfRepStatus())
            .append("fRepDate", getfRepDate())
            .toString();
    }
}
