package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急预案对象 t_plan_info
 * 
 * @author zehong
 * @date 2022-02-11
 */
public class TPlanInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 预案id */
    private Long planId;

    /** 预案标题 */
    @Excel(name = "预案标题")
    private String planTitle;

    /** 预案类型 */
    @Excel(name = "预案类型")
    private String planType;

    /** 预案等级 */
    @Excel(name = "预案等级")
    private String planLevel;

    /** 所属企业 */
    private String beyondEnterpriseId;

    /** 所属企业名称 */
    @Excel(name = "所属企业名称")
    private String beyondEnterpriseName;

    /** 应急方案 */
    @Excel(name = "应急方案")
    private String planContents;

    /** 应急设备及车辆 */
    @Excel(name = "应急设备及车辆")
    private String planEquipment;

    /** 图片路径 */
    private String iconUrl;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setPlanId(Long planId) 
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }
    public void setPlanTitle(String planTitle) 
    {
        this.planTitle = planTitle;
    }

    public String getPlanTitle() 
    {
        return planTitle;
    }
    public void setPlanType(String planType) 
    {
        this.planType = planType;
    }

    public String getPlanType() 
    {
        return planType;
    }
    public void setPlanLevel(String planLevel) 
    {
        this.planLevel = planLevel;
    }

    public String getPlanLevel() 
    {
        return planLevel;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId) 
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId() 
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setPlanContents(String planContents) 
    {
        this.planContents = planContents;
    }

    public String getPlanContents() 
    {
        return planContents;
    }
    public void setPlanEquipment(String planEquipment) 
    {
        this.planEquipment = planEquipment;
    }

    public String getPlanEquipment() 
    {
        return planEquipment;
    }
    public void setIconUrl(String iconUrl) 
    {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() 
    {
        return iconUrl;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("planId", getPlanId())
            .append("planTitle", getPlanTitle())
            .append("planType", getPlanType())
            .append("planLevel", getPlanLevel())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("planContents", getPlanContents())
            .append("planEquipment", getPlanEquipment())
            .append("iconUrl", getIconUrl())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
