package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;
import java.util.List;

/**
 * 监督检查-检查记录对象 t_ins_rec_infor
 * 
 * @author zehong
 * @date 2024-05-20
 */
public class TInsRecInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsRecInforId;

    /** 检查记录编码,实施检查的燃

            气主管部门对应 6 位行政区

            划编码+4 位年份+6 位顺序

            号 */
    @Excel(name = "检查记录编码")
    private String fCheckCode;

    /** 关联的检查任务编码 */
    @Excel(name = "关联的检查任务编码")
    private String fCheckTaskCode;

    /** 县级行政区ID */
    private String fRegionCode;

    @Excel(name = "县级行政区")
    private String countyName;

    /** 检查对象分类，按分类代码表23 分类填写

            23-0100 ：气代煤

            23-0200-0201：传统电代煤

            23-0200-0202：石墨烯

            23-0200-0203：聚能

            23-0200-0204：空气源热泵

            23-0200-0205：地源热泵

            23-9900-0301：集中供热

            23-9900-0302：光伏+

            23-9900-0303：光热+

            23-9900-0304：醇基燃料

            23-9900-0305：生物质 */
    @Excel(name = "检查对象分类",dictType = "t_type_code")
    private String fObjectType;

    /** 对象编码 */
    @Excel(name = "对象编码")
    private String fObjectCode;

    /** 检查人员id */
    @Excel(name = "检查人员id")
    private String fCheckUserId;

    /** 检查人员姓名 */
    @Excel(name = "检查人员姓名")
    private String fCheckManName;

    /** 检查人员联系电话 */
    @Excel(name = "检查人员联系电话")
    private String fCheckManPhone;

    /** 检查时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "检查时间")
    private String fCheckTime;

    /** 隐患数量，0-无隐患 */
    @Excel(name = "隐患数量")
    private String fHazardsNum;

    /** 是否需执法(1是，0否) */
    @Excel(name = "是否需执法",readConverterExp = "1=是,0=否")
    private String fDoscNeedExecute;

    /** 检查单等照片 */
    @Excel(name = "检查单等照片")
    private String fAnnex;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "最后修改时间")
    private String fLastUpdateTime;

    /** 描述 */
    @Excel(name = "描述")
    private String fRemark;

    /**
     * 上传状态0-未上传，1-已上传
     */
    @Excel(name = "上传状态",readConverterExp = "1=已上传,0=未上传")
    private String govUploadState;

    /**
     * 上传时间
     */
    @Excel(name = "上传时间",dateFormat = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date govUploadTime;

    private String taskName;

    /**
     * 隐患集合
     */
    private List<TInsHazRef> rectificationList;


    public void setfInsRecInforId(Long fInsRecInforId) 
    {
        this.fInsRecInforId = fInsRecInforId;
    }

    public Long getfInsRecInforId() 
    {
        return fInsRecInforId;
    }
    public void setfCheckCode(String fCheckCode) 
    {
        this.fCheckCode = fCheckCode;
    }

    public String getfCheckCode() 
    {
        return fCheckCode;
    }
    public void setfCheckTaskCode(String fCheckTaskCode) 
    {
        this.fCheckTaskCode = fCheckTaskCode;
    }

    public String getfCheckTaskCode() 
    {
        return fCheckTaskCode;
    }
    public void setfRegionCode(String fRegionCode) 
    {
        this.fRegionCode = fRegionCode;
    }

    public String getfRegionCode() 
    {
        return fRegionCode;
    }

    public String getCountyName() {
        return countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public void setfObjectType(String fObjectType)
    {
        this.fObjectType = fObjectType;
    }

    public String getfObjectType() 
    {
        return fObjectType;
    }
    public void setfObjectCode(String fObjectCode) 
    {
        this.fObjectCode = fObjectCode;
    }

    public String getfObjectCode() 
    {
        return fObjectCode;
    }
    public void setfCheckUserId(String fCheckUserId) 
    {
        this.fCheckUserId = fCheckUserId;
    }

    public String getfCheckUserId() 
    {
        return fCheckUserId;
    }
    public void setfCheckManName(String fCheckManName) 
    {
        this.fCheckManName = fCheckManName;
    }

    public String getfCheckManName() 
    {
        return fCheckManName;
    }
    public void setfCheckManPhone(String fCheckManPhone) 
    {
        this.fCheckManPhone = fCheckManPhone;
    }

    public String getfCheckManPhone() 
    {
        return fCheckManPhone;
    }
    public void setfCheckTime(String fCheckTime) 
    {
        this.fCheckTime = fCheckTime;
    }

    public String getfCheckTime() 
    {
        return fCheckTime;
    }
    public void setfHazardsNum(String fHazardsNum) 
    {
        this.fHazardsNum = fHazardsNum;
    }

    public String getfHazardsNum() 
    {
        return fHazardsNum;
    }
    public void setfDoscNeedExecute(String fDoscNeedExecute) 
    {
        this.fDoscNeedExecute = fDoscNeedExecute;
    }

    public String getfDoscNeedExecute() 
    {
        return fDoscNeedExecute;
    }
    public void setfAnnex(String fAnnex) 
    {
        this.fAnnex = fAnnex;
    }

    public String getfAnnex() 
    {
        return fAnnex;
    }
    public void setfLastUpdateTime(String fLastUpdateTime) 
    {
        this.fLastUpdateTime = fLastUpdateTime;
    }

    public String getfLastUpdateTime() 
    {
        return fLastUpdateTime;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public List<TInsHazRef> getRectificationList() {
        return rectificationList;
    }

    public void setRectificationList(List<TInsHazRef> rectificationList) {
        this.rectificationList = rectificationList;
    }

    public String getGovUploadState() {
        return govUploadState;
    }

    public void setGovUploadState(String govUploadState) {
        this.govUploadState = govUploadState;
    }

    public Date getGovUploadTime() {
        return govUploadTime;
    }

    public void setGovUploadTime(Date govUploadTime) {
        this.govUploadTime = govUploadTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsRecInforId", getfInsRecInforId())
            .append("fCheckCode", getfCheckCode())
            .append("fCheckTaskCode", getfCheckTaskCode())
            .append("fRegionCode", getfRegionCode())
            .append("fObjectType", getfObjectType())
            .append("fObjectCode", getfObjectCode())
            .append("fCheckUserId", getfCheckUserId())
            .append("fCheckManName", getfCheckManName())
            .append("fCheckManPhone", getfCheckManPhone())
            .append("fCheckTime", getfCheckTime())
            .append("fHazardsNum", getfHazardsNum())
            .append("fDoscNeedExecute", getfDoscNeedExecute())
            .append("fAnnex", getfAnnex())
            .append("fLastUpdateTime", getfLastUpdateTime())
            .append("fRemark", getfRemark())
            .toString();
    }
}
