package com.zehong.system.domain;

import java.util.Date;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.core.domain.BaseEntity;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 用户管理-燃气用户-安全装置加装维护对象 t_gasuser_safety_device_info
 * 
 * @author zehong
 * @date 2024-08-27
 */
public class TGasuserSafetyDeviceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 安全装置加装ID */
    private Long gasUserSafetyDeviceId;

    /** 用户管理-燃气用户关联id */
    private Long relationGasuserId;

    /** 关联设备类型 */
    @Excel(name = "设备类型")
    private String relationDeviceType;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备型号 */
    @Excel(name = "设备型号")
    private String deviceModel;

    /** 物联网编号 */
    @Excel(name = "物联网编号")
    private String fIotNo;

    /** 探测介质 */
    @Excel(name = "探测介质")
    private String detectionMedium;

    /** 设备安装时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd") // 入参
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "设备安装时间", width = 30,format="yyyy-MM-dd")
    private Date deviceInstallTime;

    /** 安装位置 */
    @Excel(name = "安装位置")
    private String deviceInstallPosition;

    /** 负责人 */
    @Excel(name = "负责人")
    private String head;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setGasUserSafetyDeviceId(Long gasUserSafetyDeviceId) 
    {
        this.gasUserSafetyDeviceId = gasUserSafetyDeviceId;
    }

    public Long getGasUserSafetyDeviceId() 
    {
        return gasUserSafetyDeviceId;
    }
    public void setRelationGasuserId(Long relationGasuserId) 
    {
        this.relationGasuserId = relationGasuserId;
    }

    public Long getRelationGasuserId() 
    {
        return relationGasuserId;
    }
    public void setRelationDeviceType(String relationDeviceType) 
    {
        this.relationDeviceType = relationDeviceType;
    }

    public String getRelationDeviceType() 
    {
        return relationDeviceType;
    }
    public void setDeviceName(String deviceName) 
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName() 
    {
        return deviceName;
    }
    public void setDeviceModel(String deviceModel) 
    {
        this.deviceModel = deviceModel;
    }

    public String getDeviceModel() 
    {
        return deviceModel;
    }
    public void setfIotNo(String fIotNo) 
    {
        this.fIotNo = fIotNo;
    }

    public String getfIotNo() 
    {
        return fIotNo;
    }
    public void setDetectionMedium(String detectionMedium) 
    {
        this.detectionMedium = detectionMedium;
    }

    public String getDetectionMedium() 
    {
        return detectionMedium;
    }
    public void setDeviceInstallTime(Date deviceInstallTime) 
    {
        this.deviceInstallTime = deviceInstallTime;
    }

    public Date getDeviceInstallTime() 
    {
        return deviceInstallTime;
    }
    public void setDeviceInstallPosition(String deviceInstallPosition)
    {
        this.deviceInstallPosition = deviceInstallPosition;
    }

    public String getDeviceInstallPosition()
    {
        return deviceInstallPosition;
    }
    public void setHead(String head) 
    {
        this.head = head;
    }

    public String getHead() 
    {
        return head;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("gasUserSafetyDeviceId", getGasUserSafetyDeviceId())
            .append("relationGasuserId", getRelationGasuserId())
            .append("relationDeviceType", getRelationDeviceType())
            .append("deviceName", getDeviceName())
            .append("deviceModel", getDeviceModel())
            .append("fIotNo", getfIotNo())
            .append("detectionMedium", getDetectionMedium())
            .append("deviceInstallTime", getDeviceInstallTime())
            .append("deviceInstallPosition", getDeviceInstallPosition())
            .append("head", getHead())
            .append("phone", getPhone())
            .append("isDel", getIsDel())
            .toString();
    }
}
