package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 燃气用户对象 t_gas_user_info
 *
 * @author zehong
 * @date 2023-08-17
 */
public class TGasUserInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 燃气用户主键 */
    private Long gasUserId;

    /** 名称 */
    @Excel(name = "用户名称")
    private String gasUserName;

    /** 代码 */
    @Excel(name = "用户编码")
    private String gasUserCode;

    /** 0.居民 1.非居民 */
    @Excel(name = "用户类型：0.居民 1.非居民")
    private String gasUserType;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String telNum;

    /** 0.正常 1.停用 */
    @Excel(name = "用户状态：0.正常 1.停用")
    private String gasUserStatus;

    /** 用户地址 */
    @Excel(name = "用户地址")
    private String gasUserAddress;

    /** 末次配送时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "末次配送时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date lastDeliveryDate;

    /** 入户安检状态：0.正常入户 1.拒绝安检 */
    @Excel(name = "入户安检状态：0.正常入户 1.拒绝安检")
    private String gasUserCheckStatus;

    /** 累计安检次数 */
    @Excel(name = "累计安检次数")
    private Integer totalCheckNum;

    /** 删除状态：0.否 1.是 */
    private String isDel;

    private String operator;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setGasUserId(Long gasUserId)
    {
        this.gasUserId = gasUserId;
    }

    public Long getGasUserId()
    {
        return gasUserId;
    }
    public void setGasUserName(String gasUserName)
    {
        this.gasUserName = gasUserName;
    }

    public String getGasUserName()
    {
        return gasUserName;
    }
    public void setGasUserCode(String gasUserCode)
    {
        this.gasUserCode = gasUserCode;
    }

    public String getGasUserCode()
    {
        return gasUserCode;
    }
    public void setGasUserType(String gasUserType)
    {
        this.gasUserType = gasUserType;
    }

    public String getGasUserType()
    {
        return gasUserType;
    }
    public void setTelNum(String telNum)
    {
        this.telNum = telNum;
    }

    public String getTelNum()
    {
        return telNum;
    }
    public void setGasUserStatus(String gasUserStatus)
    {
        this.gasUserStatus = gasUserStatus;
    }

    public String getGasUserStatus()
    {
        return gasUserStatus;
    }
    public void setGasUserAddress(String gasUserAddress)
    {
        this.gasUserAddress = gasUserAddress;
    }

    public String getGasUserAddress()
    {
        return gasUserAddress;
    }
    public void setLastDeliveryDate(Date lastDeliveryDate)
    {
        this.lastDeliveryDate = lastDeliveryDate;
    }

    public Date getLastDeliveryDate()
    {
        return lastDeliveryDate;
    }
    public void setGasUserCheckStatus(String gasUserCheckStatus)
    {
        this.gasUserCheckStatus = gasUserCheckStatus;
    }

    public String getGasUserCheckStatus()
    {
        return gasUserCheckStatus;
    }
    public void setTotalCheckNum(Integer totalCheckNum)
    {
        this.totalCheckNum = totalCheckNum;
    }

    public Integer getTotalCheckNum()
    {
        return totalCheckNum;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("gasUserId", getGasUserId())
            .append("gasUserName", getGasUserName())
            .append("gasUserCode", getGasUserCode())
            .append("gasUserType", getGasUserType())
            .append("telNum", getTelNum())
            .append("gasUserStatus", getGasUserStatus())
            .append("gasUserAddress", getGasUserAddress())
            .append("lastDeliveryDate", getLastDeliveryDate())
            .append("gasUserCheckStatus", getGasUserCheckStatus())
            .append("totalCheckNum", getTotalCheckNum())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
