package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 气瓶追溯对象 t_gas_bottle_track_record
 *
 * @author zehong
 * @date 2023-08-18
 */
public class TGasBottleTrackRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 追溯主键 */
    private Long trackRecordId;

    /** 储配站主键 */
    private Long stationId;

    /**储配站*/
    @Excel(name="储配站")
    private String stationName;

    /** 气瓶主键 */
    private Long bottleId;

    /**气瓶编号*/
    @Excel(name = "气瓶条码")
    private String bottleCode;

    /**规格*/
    @Excel(name = "气瓶规格/L")
    private String bottleCapacity;

    /** 工序名称：0.气瓶充装 1.气瓶配送 2.气瓶回收 */
    @Excel(name = "工序名称：0.气瓶充装 1.气瓶配送 2.气瓶回收")
    private String processesName;

    /** 工序关联主键用于查看 */
    private Long processesRelationId;

    /** 操作时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date operateDate;

    private String operateDates;

    /** 操作人 */
    private Long operator;

    @Excel(name = "操作人")
    private String operatorName;

    /** 发送方 */
    @Excel(name = "发送方")
    private String sender;

    /** 接收方 */
    @Excel(name = "接收方")
    private String recipient;

    /** 删除状态：0.否 1.是 */
    private String isDel;

    private String messageInfo;

    private String name;

    private String gasUserName;

    public String getGasUserName() {
        return gasUserName;
    }

    public void setGasUserName(String gasUserName) {
        this.gasUserName = gasUserName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getOperateDates() {
        return operateDates;
    }

    public void setOperateDates(String operateDates) {
        this.operateDates = operateDates;
    }

    public void setTrackRecordId(Long trackRecordId)
    {
        this.trackRecordId = trackRecordId;
    }

    public Long getTrackRecordId()
    {
        return trackRecordId;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setBottleId(Long bottleId)
    {
        this.bottleId = bottleId;
    }

    public Long getBottleId()
    {
        return bottleId;
    }

    public String getBottleCode() {
        return bottleCode;
    }

    public void setBottleCode(String bottleCode) {
        this.bottleCode = bottleCode;
    }

    public String getBottleCapacity() {
        return bottleCapacity;
    }

    public void setBottleCapacity(String bottleCapacity) {
        this.bottleCapacity = bottleCapacity;
    }

    public void setProcessesName(String processesName)
    {
        this.processesName = processesName;
    }

    public String getProcessesName()
    {
        return processesName;
    }
    public void setProcessesRelationId(Long processesRelationId)
    {
        this.processesRelationId = processesRelationId;
    }

    public Long getProcessesRelationId()
    {
        return processesRelationId;
    }
    public void setOperateDate(Date operateDate)
    {
        this.operateDate = operateDate;
    }

    public Date getOperateDate()
    {
        return operateDate;
    }
    public void setOperator(Long operator)
    {
        this.operator = operator;
    }

    public Long getOperator()
    {
        return operator;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public void setSender(String sender)
    {
        this.sender = sender;
    }

    public String getSender()
    {
        return sender;
    }
    public void setRecipient(String recipient)
    {
        this.recipient = recipient;
    }

    public String getRecipient()
    {
        return recipient;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getMessageInfo() {
        return messageInfo;
    }

    public void setMessageInfo(String messageInfo) {
        this.messageInfo = messageInfo;
    }

    @Override
    public String toString() {
        return "TGasBottleTrackRecord{" +
                "trackRecordId=" + trackRecordId +
                ", stationId=" + stationId +
                ", stationName='" + stationName + '\'' +
                ", bottleId=" + bottleId +
                ", bottleCode='" + bottleCode + '\'' +
                ", bottleCapacity='" + bottleCapacity + '\'' +
                ", processesName='" + processesName + '\'' +
                ", processesRelationId=" + processesRelationId +
                ", operateDate=" + operateDate +
                ", operateDates='" + operateDates + '\'' +
                ", operator=" + operator +
                ", operatorName='" + operatorName + '\'' +
                ", sender='" + sender + '\'' +
                ", recipient='" + recipient + '\'' +
                ", isDel='" + isDel + '\'' +
                ", messageInfo='" + messageInfo + '\'' +
                '}';
    }
}
