package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 气瓶信息对象 t_gas_bottle_info
 *
 * @author zehong
 * @date 2023-08-15
 */
public class TGasBottleInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 气瓶主键 */
    private Long bottleId;

    /** 储配站 */

    private Long stationId;

    @Excel(name = "储配站")
    private String stationName;

    /** 气瓶条码 */
    @Excel(name = "气瓶条码")
    private String bottleCode;

    /** 自有编号 */
    @Excel(name = "自有编号")
    private String myselfNum;

    /** 制造单位 */
    @Excel(name = "制造单位")
    private String produceUnit;

    /** 制造年月 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "制造年月", width = 30, dateFormat = "yyyy-MM-dd")
    private Date produceDate;

    /** 出厂编号 */
    @Excel(name = "出厂编号")
    private String produceCode;

    /** 1.正常 2.逾期未检 3.报废 */
    @Excel(name = "气瓶状态：1.正常 2.逾期未检 3.报废")
    private String bottleStatus;

    /** 末次充装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "末次充装时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lastChargeDate;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 充装介质 */
    @Excel(name = "充装介质")
    private String chargeMedium;

    /** 气瓶规格Kg/MPa */
    @Excel(name = "气瓶规格Kg/MPa")
    private String bottleSpecs;

    /** 公称压力Mpa */
    @Excel(name = "公称压力Mpa")
    private String ratedPresure;

    /** 气瓶容积L */
    @Excel(name = "气瓶容积L")
    private String bottleCapacity;

    /** 壁厚 */
    @Excel(name = "壁厚")
    private String wallThickness;

    /** 皮重 */
    @Excel(name = "皮重")
    private String tare;

    /** 使用登记代码 */
    @Excel(name = "使用登记代码")
    private String useRegisterCode;

    /** 登记日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "登记日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date registerDate;

    /** 末检日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "末检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lastCheckDate;

    /** 下检日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nextCheckDate;

    /** 报废日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "报废日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date scrapDate;

    /** 0.在站 1.离站 */
    @Excel(name = "在站/离站: 0.在站 1.离站")
    private String currentStatus;

    /** 0.空瓶 1.满瓶 */
    @Excel(name = "空满状态：0.空瓶 1.满瓶")
    private String emptyType;

    /** 删除状态：0.否 1.是 */
    private String isDel;

    private Date produceBeginTime;

    private Date produceEndTime;

    public void setBottleId(Long bottleId)
    {
        this.bottleId = bottleId;
    }

    public Long getBottleId()
    {
        return bottleId;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setBottleCode(String bottleCode)
    {
        this.bottleCode = bottleCode;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getBottleCode()
    {
        return bottleCode;
    }
    public void setMyselfNum(String myselfNum)
    {
        this.myselfNum = myselfNum;
    }

    public String getMyselfNum()
    {
        return myselfNum;
    }
    public void setProduceUnit(String produceUnit)
    {
        this.produceUnit = produceUnit;
    }

    public String getProduceUnit()
    {
        return produceUnit;
    }
    public void setProduceDate(Date produceDate)
    {
        this.produceDate = produceDate;
    }

    public Date getProduceDate()
    {
        return produceDate;
    }
    public void setProduceCode(String produceCode)
    {
        this.produceCode = produceCode;
    }

    public String getProduceCode()
    {
        return produceCode;
    }
    public void setBottleStatus(String bottleStatus)
    {
        this.bottleStatus = bottleStatus;
    }

    public String getBottleStatus()
    {
        return bottleStatus;
    }
    public void setLastChargeDate(Date lastChargeDate)
    {
        this.lastChargeDate = lastChargeDate;
    }

    public Date getLastChargeDate()
    {
        return lastChargeDate;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setChargeMedium(String chargeMedium)
    {
        this.chargeMedium = chargeMedium;
    }

    public String getChargeMedium()
    {
        return chargeMedium;
    }
    public void setBottleSpecs(String bottleSpecs)
    {
        this.bottleSpecs = bottleSpecs;
    }

    public String getBottleSpecs()
    {
        return bottleSpecs;
    }
    public void setRatedPresure(String ratedPresure)
    {
        this.ratedPresure = ratedPresure;
    }

    public String getRatedPresure()
    {
        return ratedPresure;
    }
    public void setBottleCapacity(String bottleCapacity)
    {
        this.bottleCapacity = bottleCapacity;
    }

    public String getBottleCapacity()
    {
        return bottleCapacity;
    }
    public void setWallThickness(String wallThickness)
    {
        this.wallThickness = wallThickness;
    }

    public String getWallThickness()
    {
        return wallThickness;
    }
    public void setTare(String tare)
    {
        this.tare = tare;
    }

    public String getTare()
    {
        return tare;
    }
    public void setUseRegisterCode(String useRegisterCode)
    {
        this.useRegisterCode = useRegisterCode;
    }

    public String getUseRegisterCode()
    {
        return useRegisterCode;
    }
    public void setRegisterDate(Date registerDate)
    {
        this.registerDate = registerDate;
    }

    public Date getRegisterDate()
    {
        return registerDate;
    }
    public void setLastCheckDate(Date lastCheckDate)
    {
        this.lastCheckDate = lastCheckDate;
    }

    public Date getLastCheckDate()
    {
        return lastCheckDate;
    }
    public void setNextCheckDate(Date nextCheckDate)
    {
        this.nextCheckDate = nextCheckDate;
    }

    public Date getNextCheckDate()
    {
        return nextCheckDate;
    }
    public void setScrapDate(Date scrapDate)
    {
        this.scrapDate = scrapDate;
    }

    public Date getScrapDate()
    {
        return scrapDate;
    }
    public void setCurrentStatus(String currentStatus)
    {
        this.currentStatus = currentStatus;
    }

    public String getCurrentStatus()
    {
        return currentStatus;
    }
    public void setEmptyType(String emptyType)
    {
        this.emptyType = emptyType;
    }

    public String getEmptyType()
    {
        return emptyType;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    public Date getProduceBeginTime() {
        return produceBeginTime;
    }

    public void setProduceBeginTime(Date produceBeginTime) {
        this.produceBeginTime = produceBeginTime;
    }

    public Date getProduceEndTime() {
        return produceEndTime;
    }

    public void setProduceEndTime(Date produceEndTime) {
        this.produceEndTime = produceEndTime;
    }

    @Override
    public String toString() {
        return "TGasBottleInfo{" +
                "bottleId=" + bottleId +
                ", stationId=" + stationId +
                ", stationName='" + stationName + '\'' +
                ", bottleCode='" + bottleCode + '\'' +
                ", myselfNum='" + myselfNum + '\'' +
                ", produceUnit='" + produceUnit + '\'' +
                ", produceDate=" + produceDate +
                ", produceCode='" + produceCode + '\'' +
                ", bottleStatus='" + bottleStatus + '\'' +
                ", lastChargeDate=" + lastChargeDate +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", chargeMedium='" + chargeMedium + '\'' +
                ", bottleSpecs='" + bottleSpecs + '\'' +
                ", ratedPresure='" + ratedPresure + '\'' +
                ", bottleCapacity='" + bottleCapacity + '\'' +
                ", wallThickness='" + wallThickness + '\'' +
                ", tare='" + tare + '\'' +
                ", useRegisterCode='" + useRegisterCode + '\'' +
                ", registerDate=" + registerDate +
                ", lastCheckDate=" + lastCheckDate +
                ", nextCheckDate=" + nextCheckDate +
                ", scrapDate=" + scrapDate +
                ", currentStatus='" + currentStatus + '\'' +
                ", emptyType='" + emptyType + '\'' +
                ", isDel='" + isDel + '\'' +
                ", produceBeginTime=" + produceBeginTime +
                ", produceEndTime=" + produceEndTime +
                '}';
    }
}
