package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 事件接报对象 t_event_receive
 * 
 * @author zehong
 * @date 2022-03-18
 */
public class TEventReceive extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Integer id;

    /** 事件名称 */
    @Excel(name = "事件名称")
    private String eventName;

    /** 事件类型 1水灾 2火灾 3突发 */
    @Excel(name = "事件类型 1水灾 2火灾 3突发")
    private Integer eventType;

    /** 事件等级 1级 2级 3级 */
    @Excel(name = "事件等级 1级 2级 3级")
    private Integer eventGrade;

    /** 事发地点 */
    @Excel(name = "事发地点")
    private String address;

    /** 经度 */
    private String longitude;

    /** 纬度 */
    private String latitude;

    /** 报案人 */
    @Excel(name = "报案人")
    private String informant;

    /** 报案时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "报案时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date inforTime;

    /** 报案人电话 */
    @Excel(name = "报案人电话")
    private String informantPhone;

    /** 事件描述 */
    @Excel(name = "事件描述")
    private String describe;

    /** 指派公司id */
    @Excel(name = "指派公司id")
    private String enterpriseId;

    /** 指派公司名称 */
    @Excel(name = "指派公司名称")
    private String enterpriseName;

    /** 备注 */
    private String remarks;

    private Integer companyRead;

    private Integer  governmentRead;
    /** 0未删除 1已删除 */
    private Integer isDel;
    @Excel(name = "状态")
    private Integer status;

    private TEventHandle handleList;

    public TEventHandle getHandleList() {
        return handleList;
    }

    public void setHandleList(TEventHandle handleList) {
        this.handleList = handleList;
    }

    public Integer getCompanyRead() {
        return companyRead;
    }

    public void setCompanyRead(Integer companyRead) {
        this.companyRead = companyRead;
    }

    public Integer getGovernmentRead() {
        return governmentRead;
    }

    public void setGovernmentRead(Integer governmentRead) {
        this.governmentRead = governmentRead;
    }

    public void setId(Integer id)
    {
        this.id = id;
    }

    public Integer getId()
    {
        return id;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setEventName(String eventName)
    {
        this.eventName = eventName;
    }

    public String getEventName() 
    {
        return eventName;
    }
    public void setEventType(Integer eventType) 
    {
        this.eventType = eventType;
    }

    public Integer getEventType() 
    {
        return eventType;
    }
    public void setEventGrade(Integer eventGrade) 
    {
        this.eventGrade = eventGrade;
    }

    public Integer getEventGrade() 
    {
        return eventGrade;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(String longitude) 
    {
        this.longitude = longitude;
    }

    public String getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(String latitude) 
    {
        this.latitude = latitude;
    }

    public String getLatitude() 
    {
        return latitude;
    }
    public void setInformant(String informant) 
    {
        this.informant = informant;
    }

    public String getInformant() 
    {
        return informant;
    }
    public void setInforTime(Date inforTime) 
    {
        this.inforTime = inforTime;
    }

    public Date getInforTime() 
    {
        return inforTime;
    }
    public void setInformantPhone(String informantPhone) 
    {
        this.informantPhone = informantPhone;
    }

    public String getInformantPhone() 
    {
        return informantPhone;
    }
    public void setDescribe(String describe) 
    {
        this.describe = describe;
    }

    public String getDescribe() 
    {
        return describe;
    }
    public void setEnterpriseId(String enterpriseId)
    {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseId()
    {
        return enterpriseId;
    }
    public void setEnterpriseName(String enterpriseName) 
    {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseName() 
    {
        return enterpriseName;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("eventName", getEventName())
            .append("eventType", getEventType())
            .append("eventGrade", getEventGrade())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("informant", getInformant())
            .append("inforTime", getInforTime())
            .append("informantPhone", getInformantPhone())
            .append("describe", getDescribe())
            .append("enterpriseId", getEnterpriseId())
            .append("enterpriseName", getEnterpriseName())
            .append("remarks", getRemarks())
            .append("isDel", getIsDel())
            .append("createTime", getCreateTime())
            .toString();
    }
}
