package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 从业人员错误导入记录对象 t_employed_people_info_error
 * 
 * @author zehong
 * @date 2024-06-01
 */
public class TEmployedPeopleInfoError extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    @Excel(name = "id/此列内容不允许修改")
    private Long employedPeopleErrorId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String employedPeopleName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 职业技能岗位证书编号 */
    @Excel(name = "职业技能岗位证书编号")
    private String certificateNum;

    /** 受聘企业名称 */
    @Excel(name = "受聘企业名称")
    private String beyondEnterpriseName;

    /** 报考类型 */
    @Excel(name = "报考类型")
    private String registerExaminationType;

    /** 人员类型：1.主要负责人 2.安全管理人员3.运行维护和抢修人员 */
    @Excel(name = "人员类型")
    private String peopleOccupation;

    /** 发证日期 */
    @Excel(name = "发证日期")
    private String issueDate;

    /** 复检日期 */
    @Excel(name = "复检日期")
    private String certificateChange;


    /** 错误信息 */
    @Excel(name = "错误信息")
    private String errorMsg;

    public void setEmployedPeopleErrorId(Long employedPeopleErrorId) 
    {
        this.employedPeopleErrorId = employedPeopleErrorId;
    }

    public Long getEmployedPeopleErrorId() 
    {
        return employedPeopleErrorId;
    }
    public void setEmployedPeopleName(String employedPeopleName) 
    {
        this.employedPeopleName = employedPeopleName;
    }

    public String getEmployedPeopleName() 
    {
        return employedPeopleName;
    }
    public void setIdCard(String idCard) 
    {
        this.idCard = idCard;
    }

    public String getIdCard() 
    {
        return idCard;
    }
    public void setCertificateNum(String certificateNum) 
    {
        this.certificateNum = certificateNum;
    }

    public String getCertificateNum() 
    {
        return certificateNum;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setRegisterExaminationType(String registerExaminationType) 
    {
        this.registerExaminationType = registerExaminationType;
    }

    public String getRegisterExaminationType() 
    {
        return registerExaminationType;
    }
    public void setPeopleOccupation(String peopleOccupation) 
    {
        this.peopleOccupation = peopleOccupation;
    }

    public String getPeopleOccupation() 
    {
        return peopleOccupation;
    }
    public void setIssueDate(String issueDate) 
    {
        this.issueDate = issueDate;
    }

    public String getIssueDate() 
    {
        return issueDate;
    }
    public void setCertificateChange(String certificateChange) 
    {
        this.certificateChange = certificateChange;
    }

    public String getCertificateChange() 
    {
        return certificateChange;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("employedPeopleErrorId", getEmployedPeopleErrorId())
            .append("employedPeopleName", getEmployedPeopleName())
            .append("idCard", getIdCard())
            .append("certificateNum", getCertificateNum())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("registerExaminationType", getRegisterExaminationType())
            .append("peopleOccupation", getPeopleOccupation())
            .append("issueDate", getIssueDate())
            .append("certificateChange", getCertificateChange())
            .append("createBy", getCreateBy())
            .toString();
    }
}
