package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急演练对象 t_emergency_drills
 * 
 * @author zehong
 * @date 2024-04-19
 */
public class TEmergencyDrills extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 演练ID */
    private Long fDrillsId;

    /** 演练时间 */
    @Excel(name = "演练时间")
    private String fDrillsTime;

    /** 事件 */
    @Excel(name = "事件")
    private String fEvent;

    /** 地点 */
    @Excel(name = "地点")
    private String fPlace;

    /** 参与演练人员 */
    @Excel(name = "参与演练人员")
    private String fPerDep;

    /**  参与演练部门 */
    @Excel(name = "参与演练部门")
    private String fDrillDepartment;

    public String getfDrillDepartment() {
        return fDrillDepartment;
    }

    public void setfDrillDepartment(String fDrillDepartment) {
        this.fDrillDepartment = fDrillDepartment;
    }

    /** 演练内容 */
    private String fDrillsContent;


    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date fCreateTime;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date fUpdateTime;

    /** 是否删除(0正常，1删除) */
    private String fIsDel;

    /** 备注 */
    private String fRemarks;

    public void setfDrillsId(Long fDrillsId) 
    {
        this.fDrillsId = fDrillsId;
    }

    public Long getfDrillsId() 
    {
        return fDrillsId;
    }
    public void setfDrillsTime(String fDrillsTime) 
    {
        this.fDrillsTime = fDrillsTime;
    }

    public String getfDrillsTime() 
    {
        return fDrillsTime;
    }
    public void setfEvent(String fEvent) 
    {
        this.fEvent = fEvent;
    }

    public String getfEvent() 
    {
        return fEvent;
    }
    public void setfPlace(String fPlace) 
    {
        this.fPlace = fPlace;
    }

    public String getfPlace() 
    {
        return fPlace;
    }
    public void setfPerDep(String fPerDep) 
    {
        this.fPerDep = fPerDep;
    }

    public String getfPerDep() 
    {
        return fPerDep;
    }
    public void setfDrillsContent(String fDrillsContent) 
    {
        this.fDrillsContent = fDrillsContent;
    }

    public String getfDrillsContent() 
    {
        return fDrillsContent;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfUpdateTime(Date fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public Date getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfIsDel(String fIsDel) 
    {
        this.fIsDel = fIsDel;
    }

    public String getfIsDel() 
    {
        return fIsDel;
    }
    public void setfRemarks(String fRemarks) 
    {
        this.fRemarks = fRemarks;
    }

    public String getfRemarks() 
    {
        return fRemarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fDrillsId", getfDrillsId())
            .append("fDrillsTime", getfDrillsTime())
            .append("fEvent", getfEvent())
            .append("fPlace", getfPlace())
            .append("fPerDep", getfPerDep())
            .append("fDrillsContent", getfDrillsContent())
            .append("fDrillDepartment", getfDrillDepartment())
            .append("fCreateTime", getfCreateTime())
            .append("fUpdateTime", getfUpdateTime())
            .append("fIsDel", getfIsDel())
            .append("fRemarks", getfRemarks())
            .toString();
    }
}
