package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气用户错误导入记录对象 t_detector_user_error
 * 
 * @author zehong
 * @date 2024-08-30
 */
public class TDetectorUserError extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 用户id */
    private Long userId;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String nickName;

    /** 权属单位名称 */
    @Excel(name = "权属单位名称")
    private String beyondEnterpriseName;

    /**
     * 导入数据的企业
     */
    private String beyondEnterpriseId;

    /** 用户类型（1居民用户，2商业用户，3工业用户,4餐饮单位用户） */
    @Excel(name = "用户类型", readConverterExp = "1=居民用户，2商业用户，3工业用户,4餐饮单位用户")
    private String userType;

    /** 燃气类型(0-天然气，1-液化气) */
    @Excel(name = "燃气类型(0-天然气，1-液化气)")
    private String gasType;

    /** 居住区(村、庄)名称 */
    @Excel(name = "居住区(村、庄)名称")
    private String villageName;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 错误信息 */
    @Excel(name = "错误信息")
    private String errorMsg;

    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setNickName(String nickName) 
    {
        this.nickName = nickName;
    }

    public String getNickName() 
    {
        return nickName;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setUserType(String userType) 
    {
        this.userType = userType;
    }

    public String getUserType() 
    {
        return userType;
    }
    public void setGasType(String gasType) 
    {
        this.gasType = gasType;
    }

    public String getGasType() 
    {
        return gasType;
    }
    public void setVillageName(String villageName) 
    {
        this.villageName = villageName;
    }

    public String getVillageName() 
    {
        return villageName;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLinkman(String linkman) 
    {
        this.linkman = linkman;
    }

    public String getLinkman() 
    {
        return linkman;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setErrorMsg(String errorMsg) 
    {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() 
    {
        return errorMsg;
    }

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("userId", getUserId())
            .append("nickName", getNickName())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("userType", getUserType())
            .append("gasType", getGasType())
            .append("villageName", getVillageName())
            .append("address", getAddress())
            .append("linkman", getLinkman())
            .append("phone", getPhone())
            .append("remarks", getRemarks())
            .append("errorMsg", getErrorMsg())
            .toString();
    }
}
