package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 县级行政区对象 t_county_level_region
 * 
 * @author zehong
 * @date 2024-06-06
 */
public class TCountyLevelRegion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 县级行政区 ID，表主键，非自增 */
    private Long fId;

    /** 所属市 id */
    @Excel(name = "所属市 id")
    private Long fCityId;

    /** 县（市、区）行政区划编码 */
    @Excel(name = "县", readConverterExp = "市=、区")
    private String fCountyCode;

    /** 市名称 */
    @Excel(name = "市名称")
    private String fName;

    /** 0 否，1 是 */
    @Excel(name = "0 否，1 是")
    private Long fIsMajor;

    // 排序
    private Long seq;

    public void setfId(Long fId) 
    {
        this.fId = fId;
    }

    public Long getfId() 
    {
        return fId;
    }
    public void setfCityId(Long fCityId) 
    {
        this.fCityId = fCityId;
    }

    public Long getfCityId() 
    {
        return fCityId;
    }
    public void setfCountyCode(String fCountyCode) 
    {
        this.fCountyCode = fCountyCode;
    }

    public String getfCountyCode() 
    {
        return fCountyCode;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfIsMajor(Long fIsMajor) 
    {
        this.fIsMajor = fIsMajor;
    }

    public Long getfIsMajor() 
    {
        return fIsMajor;
    }

    public Long getSeq() {
        return seq;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fId", getfId())
            .append("fCityId", getfCityId())
            .append("fCountyCode", getfCountyCode())
            .append("fName", getfName())
            .append("fIsMajor", getfIsMajor())
            .toString();
    }
}
