package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 市级行政区对象 t_city_level_region
 * 
 * @author zehong
 * @date 2024-06-06
 */
public class TCityLevelRegion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fId;

    /** 市行政区划编码 */
    @Excel(name = "市行政区划编码")
    private String fCityCode;

    /** 市名称 */
    @Excel(name = "市名称")
    private String fName;

    /** 配列序号 */
    @Excel(name = "配列序号")
    private Long fSeq;

    public void setfId(Long fId) 
    {
        this.fId = fId;
    }

    public Long getfId() 
    {
        return fId;
    }
    public void setfCityCode(String fCityCode) 
    {
        this.fCityCode = fCityCode;
    }

    public String getfCityCode() 
    {
        return fCityCode;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfSeq(Long fSeq) 
    {
        this.fSeq = fSeq;
    }

    public Long getfSeq() 
    {
        return fSeq;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fId", getfId())
            .append("fCityCode", getfCityCode())
            .append("fName", getfName())
            .append("fSeq", getfSeq())
            .toString();
    }
}
