package com.zehong.system.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDoubleBook;
import com.zehong.system.service.ITDoubleBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 双代台账Controller
 * 
 * @author zehong
 * @date 2024-04-21
 */
@RestController
@RequestMapping("/system/book")
public class TDoubleBookController extends BaseController
{
    @Autowired
    private ITDoubleBookService tDoubleBookService;

    /**
     * 查询双代台账列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDoubleBook tDoubleBook)
    {
        startPage();
        List<TDoubleBook> list = tDoubleBookService.selectTDoubleBookList(tDoubleBook);
        return getDataTable(list);
    }

    /**
     * 导出双代台账列表
     */
    @Log(title = "双代台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDoubleBook tDoubleBook)
    {
        List<TDoubleBook> list = tDoubleBookService.exportTDoubleBookList(tDoubleBook);
        ExcelUtil<TDoubleBook> util = new ExcelUtil<TDoubleBook>(TDoubleBook.class);
        return util.exportExcel(list, "双代台账数据");
    }

    /**
     * 获取双代台账详细信息
     */
    @GetMapping(value = "/{bookId}")
    public AjaxResult getInfo(@PathVariable("bookId") Long bookId)
    {
        return AjaxResult.success(tDoubleBookService.selectTDoubleBookById(bookId));
    }

    /**
     * 新增双代台账
     */
    @Log(title = "双代台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDoubleBook tDoubleBook)
    {
        return toAjax(tDoubleBookService.insertTDoubleBook(tDoubleBook));
    }

    /**
     * 修改双代台账
     */
    @Log(title = "双代台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDoubleBook tDoubleBook)
    {
        return toAjax(tDoubleBookService.updateTDoubleBook(tDoubleBook));
    }

    /**
     * 删除双代台账
     */
    @Log(title = "双代台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bookIds}")
    public AjaxResult remove(@PathVariable Long[] bookIds)
    {
        return toAjax(tDoubleBookService.deleteTDoubleBookByIds(bookIds));
    }
}
