package com.zehong.system.config.ureport;

import com.bstek.ureport.console.UReportServlet;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import java.sql.Connection;


@Configuration
public class UReportConfig implements BuildinDatasource {
    @Autowired
    private DataSource datasource;

    @Bean
    public ServletRegistrationBean ureport2Servlet() {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean(new UReportServlet(), "/ureport/*");
        return registrationBean;
    }

    @Override
    public String name() {
        return "内部数据源";
    }

    @SneakyThrows
    @Override
    public Connection getConnection() {
        return datasource.getConnection();
    }
}
