package com.zehong.system.config.ureport;

import com.zehong.common.constant.HttpStatus;
import lombok.Data;

@Data
public class ResponseData<T> {

    private Boolean success;

    private Integer code;

    private String msg;

    private T data;

    public ResponseData(){

    }

    public ResponseData(Boolean success, Integer code, String msg, T data) {
        this.success = success;
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <T> ResponseData<T> success(String msg, T data){
        return new ResponseData<T>(true, HttpStatus.SUCCESS,msg,data);
    }

    public static <T> ResponseData<T> success(String msg){
        return ResponseData.success(msg,null);
    }

    public static <T> ResponseData<T> success(T data){
        return ResponseData.success(null,data);
    }

    public static <T> ResponseData<T> success(){
        return ResponseData.success("请求成功",null);
    }

    public static <T> ResponseData<T> error(Integer code, String msg, T data){
        return new ResponseData<T>(false,code,msg,data);
    }

    public static <T> ResponseData<T> error(Integer code, String msg){
        return ResponseData.error(code,msg,null);
    }

    public static <T> ResponseData<T> error(String msg){
        return ResponseData.error(HttpStatus.ERROR,msg,null);
    }

    public static <T> ResponseData<T> error(){
        return ResponseData.error(HttpStatus.ERROR,"操作失败",null);
    }
}
