package com.zehong.common.enums;

import lombok.Getter;

@Getter
public enum ResultEnum {
	
	SUCCESS(0,"成功"),
	
	PARAM_ERROR(10000,"参数不正确"),
	
	NOT_EXIST(20000,"记录不存在"),
	
	ACCOUNT_EXIST(20001,"帐号已存在"),
	
	LOGIN_FAIL(30000,"登录失败"),
	
	ACCOUNT_NO(30001,"账号不存在"),
	
	ACCOUNT_PWD_ERROR(30002,"登录失败，账号或密码错误"),
	
	ACCOUNT_LOCKED(30003,"账号冻结"),
	
	LOGOUT_FAIL(30004,"登出失败"),
	
	AUTH_FAIL(30005,"认证失败"),
	
	AUTH_INFO_ERROR(30006,"认证信息异常"),
	
	ERROR_PERMISSION(30007,"权限不足"),
	
	ERROR_JWT(30008,"凭证认证失败"),
	
	EXPIRED_JWT(30009,"失效的jwtToken"),
	
	ACCOUNT_PWD_EMPTY(30010,"登录失败，帐号或密码不能为空"),
	
	ACCOUNT_OLD_PWD_ERROR(30011,"旧密码错误"),
	
	OPERATION_FAIL(4000,"操作失败"),
	
	INDICATOR_CREATE_FAIL(4001,"新增失败，最多添加3个引领性指标！"),
	
	ORG_CREATE_FAIL(4002,"新增失败，该主管在该时间段内已存在至关重要指标！"),	
	
	REQUEST_METHOD_SUPPORT_ERROR(4003,"当前请求方法不支持"),
	
	MEETING_CREATE_FAIL(4004,"本周已填写至关重要目标会议！"),
	
	SERVER_FAIL(5000,"服务器开小差了~~"),
	
	INTERNAL_SERVER_ERROR(5001, "服务器内部错误!"),
	
    SERVER_BUSY(5002, "服务器正忙，请稍后再试!"),
    
    ENTERPRISE_EXIST(6000, "企业机构代码已注册!"),
    
    ENTERPRISE_NOEXIST(6001, "企业机构代码不存在!"),
    
    DETECTOR_NOEXIST(7000, "探测器编号不存在！")
    
	;

	private Integer code;
	
	private String message;

	ResultEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}
	
	
}
