package com.zehong.web.timeconfig;
import javax.xml.crypto.Data;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 时间工具类
 */
public class TimeConFig {

    /**
     * string时间戳转换时间方法
     */
    public String setTime(String time) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        Date d = format.parse(time.replace("Z", " UTC"));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(d);
      return dateString;
    }

    /**
     * string转换成data类型
     */
    public Date  getDate(String time) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat( "yyyy-MM-dd ");
        Date date = formatter.parse(time);
        return date;
    }

    /**
     * date类型时间加一天
     */
    public Date getDateOne(Date time){
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(Calendar.DATE, 1);
        time = cal.getTime();
        return time;
    }

}
