package com.zehong.web.controller.trainmanage;

import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTrainManage;
import com.zehong.system.service.ITTrainManageService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 培训管理Controller
 * 
 * @author zehong
 * @date 2023-04-21
 */
@RestController
@RequestMapping("/train/manage")
public class TTrainManageController extends BaseController
{
    @Autowired
    private ITTrainManageService tTrainManageService;

    @Autowired
    private TokenService tokenService;

    /**
     * 查询培训管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTrainManage tTrainManage)
    {
        startPage();
        List<TTrainManage> list = tTrainManageService.selectTTrainManageList(tTrainManage);
        return getDataTable(list);
    }

    /**
     * 导出培训管理列表
     */
    @Log(title = "培训管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTrainManage tTrainManage)
    {
        List<TTrainManage> list = tTrainManageService.selectTTrainManageList(tTrainManage);
        ExcelUtil<TTrainManage> util = new ExcelUtil<TTrainManage>(TTrainManage.class);
        return util.exportExcel(list, "培训管理数据");
    }

    /**
     * 获取培训管理详细信息
     */
    @GetMapping(value = "/{trainManageId}")
    public AjaxResult getInfo(@PathVariable("trainManageId") Long trainManageId)
    {
        return AjaxResult.success(tTrainManageService.selectTTrainManageById(trainManageId));
    }

    /**
     * 新增培训管理
     */
    @Log(title = "培训管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTrainManage tTrainManage)
    {
        return toAjax(tTrainManageService.insertTTrainManage(tTrainManage));
    }

    /**
     * 修改培训管理
     */
    @Log(title = "培训管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTrainManage tTrainManage)
    {
        return toAjax(tTrainManageService.updateTTrainManage(tTrainManage));
    }

    /**
     * 删除培训管理
     */
    @Log(title = "培训管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{trainManageIds}")
    public AjaxResult remove(@PathVariable Long[] trainManageIds)
    {
        return toAjax(tTrainManageService.deleteTTrainManageByIds(trainManageIds));
    }

    /**
     * 根据培训人员查询培训课程
     * @return
     */
    @RequestMapping("/getTrainInfoByPersonId")
    public AjaxResult getTrainInfoByPersonId(){
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        return AjaxResult.success(tTrainManageService.getTrainInfoByPersonId(user.getUserId()));
    }
}
