package com.zehong.web.controller.task;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkTaskPatrolCard;
import com.zehong.system.service.ITWorkTaskPatrolCardService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2023-09-15
 */
@RestController
@RequestMapping("/system/card")
public class TWorkTaskPatrolCardController extends BaseController
{
    @Autowired
    private ITWorkTaskPatrolCardService tWorkTaskPatrolCardService;

    /**
     * 查询【请填写功能名称】列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        startPage();
        List<TWorkTaskPatrolCard> list = tWorkTaskPatrolCardService.selectTWorkTaskPatrolCardList(tWorkTaskPatrolCard);
        return getDataTable(list);
    }

    @GetMapping("/patrolCardInfoList")
    public AjaxResult patrolCardInfoList(TWorkTaskPatrolCard tWorkTaskPatrolCard){
        List<TWorkTaskPatrolCard> list = tWorkTaskPatrolCardService.selectTWorkTaskPatrolCardList(tWorkTaskPatrolCard);
        return AjaxResult.success(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        List<TWorkTaskPatrolCard> list = tWorkTaskPatrolCardService.selectTWorkTaskPatrolCardList(tWorkTaskPatrolCard);
        ExcelUtil<TWorkTaskPatrolCard> util = new ExcelUtil<TWorkTaskPatrolCard>(TWorkTaskPatrolCard.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @GetMapping(value = "/{cardId}")
    public AjaxResult getInfo(@PathVariable("cardId") Long cardId)
    {
        return AjaxResult.success(tWorkTaskPatrolCardService.selectTWorkTaskPatrolCardById(cardId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        return toAjax(tWorkTaskPatrolCardService.insertTWorkTaskPatrolCard(tWorkTaskPatrolCard));
    }

    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping(value = "/addbytaskId")
    public AjaxResult addbytaskId(@RequestBody TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        return toAjax(tWorkTaskPatrolCardService.addbytaskId(tWorkTaskPatrolCard));
    }
    /**
     * 修改【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        return toAjax(tWorkTaskPatrolCardService.updateTWorkTaskPatrolCard(tWorkTaskPatrolCard));
    }

    /**
     * 删除【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{cardIds}")
    public AjaxResult remove(@PathVariable Long[] cardIds)
    {
        return toAjax(tWorkTaskPatrolCardService.deleteTWorkTaskPatrolCardByIds(cardIds));
    }
}
