package com.zehong.web.controller.task;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TLinePatrol;
import com.zehong.system.service.ITLinePatrolService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡线Controller
 *
 * @author zehong
 * @date 2026-02-02
 */
@RestController
@RequestMapping("/line/patrol")
public class TLinePatrolController extends BaseController
{
    @Autowired
    private ITLinePatrolService tLinePatrolService;

    /**
     * 查询巡线列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLinePatrol tLinePatrol)
    {
        startPage();
        List<TLinePatrol> list = tLinePatrolService.selectTLinePatrolList(tLinePatrol);
        return getDataTable(list);
    }

    /**
     * 导出巡线列表
     */
    @Log(title = "巡线", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLinePatrol tLinePatrol)
    {
        List<TLinePatrol> list = tLinePatrolService.selectTLinePatrolList(tLinePatrol);
        ExcelUtil<TLinePatrol> util = new ExcelUtil<TLinePatrol>(TLinePatrol.class);
        return util.exportExcel(list, "巡线数据");
    }

    /**
     * 获取巡线详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tLinePatrolService.selectTLinePatrolById(id));
    }

    /**
     * 新增巡线
     */
    @Log(title = "巡线", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLinePatrol tLinePatrol)
    {
        return toAjax(tLinePatrolService.insertTLinePatrol(tLinePatrol));
    }

    /**
     * 修改巡线
     */
    @Log(title = "巡线", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLinePatrol tLinePatrol)
    {
        return toAjax(tLinePatrolService.updateTLinePatrol(tLinePatrol));
    }

    /**
     * 删除巡线
     */
    @Log(title = "巡线", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tLinePatrolService.deleteTLinePatrolByIds(ids));
    }
}