package com.zehong.web.controller.system;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TTaskRecord;
import com.zehong.system.service.ITTaskRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 任务记录Controller
 *
 * @author zehong
 * @date 2023-11-06
 */
@RestController
@RequestMapping("/system/records")
public class TTaskRecordController extends BaseController
{
    @Autowired
    private ITTaskRecordService tTaskRecordService;

    /**
     * 查询任务记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTaskRecord tTaskRecord)
    {
        startPage();
        List<TTaskRecord> list = tTaskRecordService.selectTTaskRecordList(tTaskRecord);
        return getDataTable(list);
    }

    /**
     * 导出任务记录列表
     */
    @Log(title = "任务记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTaskRecord tTaskRecord)
    {
        List<TTaskRecord> list = tTaskRecordService.selectTTaskRecordList(tTaskRecord);
        ExcelUtil<TTaskRecord> util = new ExcelUtil<TTaskRecord>(TTaskRecord.class);
        return util.exportExcel(list, "任务记录数据");
    }

    /**
     * 获取任务记录详细信息
     */
    @GetMapping(value = "/{taskRecordId}")
    public AjaxResult getInfo(@PathVariable("taskRecordId") Long taskRecordId)
    {
        return AjaxResult.success(tTaskRecordService.selectTTaskRecordById(taskRecordId));
    }

    /**
     * 新增任务记录
     */
    @Log(title = "任务记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTaskRecord tTaskRecord)
    {
        return toAjax(tTaskRecordService.insertTTaskRecord(tTaskRecord));
    }

    /**
     * 修改任务记录
     */
    @Log(title = "任务记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTaskRecord tTaskRecord)
    {
        return toAjax(tTaskRecordService.updateTTaskRecord(tTaskRecord));
    }

    /**
     * 删除任务记录
     */
    @Log(title = "任务记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{taskRecordIds}")
    public AjaxResult remove(@PathVariable Long[] taskRecordIds)
    {
        return toAjax(tTaskRecordService.deleteTTaskRecordByIds(taskRecordIds));
    }
}
