package com.zehong.web.controller.supplybalance;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.TSupBalGasSup;
import com.zehong.system.service.ITSupBalGasSupService;
import com.zehong.web.controller.tool.TimeConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供需平衡-气量监管Controller
 * 
 * @author zehong
 * @date 2024-06-15
 */
@RestController
@RequestMapping("/supplyBalance/gas")
public class TSupBalGasSupController extends BaseController
{
    @Autowired
    private ITSupBalGasSupService tSupBalGasSupService;

    /**
     * 查询供需平衡-气量监管列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupBalGasSup tSupBalGasSup)
    {
        startPage();
        if("-2".equals(SecurityUtils.getLoginUser().getUser().getDeptId())){
            tSupBalGasSup.setfRepStatus("1");
        }
        List<TSupBalGasSup> list = tSupBalGasSupService.selectTSupBalGasSupList(tSupBalGasSup);
        return getDataTable(list);
    }

    /**
     * 气量监管统计
     */
    @GetMapping("/tSupBalGasSupStatistics")
    public AjaxResult tSupBalGasSupStatistics()
    {
        List<Statistics> list=new ArrayList<>();
        //生成近7天数据
        List<String> sevenDate = TimeConfig.getSevenDate();
        //查询统计日期和数量
        List<Statistics> statistics = tSupBalGasSupService.tSupBalGasSupStatistics(sevenDate);

        Map<String, List<Statistics>> collect = statistics.stream().collect(Collectors.groupingBy(e -> e.getDate()));
        for (String s : sevenDate) {
            List<Statistics> statistics1 = collect.get(s);
            Statistics statisticsn=new Statistics();
            if(statistics1!=null && statistics1.size()>0){
                statisticsn.setCount(statistics1.get(0).getCount());
                statisticsn.setCount1(statistics1.get(0).getCount1());
                statisticsn.setCount2(statistics1.get(0).getCount2());
                statisticsn.setCount3(statistics1.get(0).getCount3());
            }else{
                statisticsn.setCount(0);
                statisticsn.setCount1(0);
                statisticsn.setCount2(0);
                statisticsn.setCount3(0);
            }
            statisticsn.setDate(s);
            list.add(statisticsn);
        }

        return AjaxResult.success(list);
    }

    /**
     * 导出供需平衡-气量监管列表
     */
    @Log(title = "供需平衡-气量监管", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupBalGasSup tSupBalGasSup){

        LoginUser loginUser = SecurityUtils.getLoginUser();

        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            tSupBalGasSup.setfRepStatus("1");
        }
        List<TSupBalGasSup> list = tSupBalGasSupService.selectTSupBalGasSupList(tSupBalGasSup);
        ExcelUtil<TSupBalGasSup> util = new ExcelUtil<>(TSupBalGasSup.class);
        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
//            List<String> columns = new ArrayList<>();
//            columns.add("fRepStatus");
//            columns.add("fRepDate");
//            util.hideColumns(util.clazz,columns);
            ExcelUtil.hiddencolumns.add(6);
            ExcelUtil.hiddencolumns.add(7);
        }else{
//            List<String> columns = new ArrayList<>();
//            columns.add("fGovUploadStatus");
//            columns.add("fGovUploadTime");
//            util.hideColumns(util.clazz,columns);
            ExcelUtil.hiddencolumns.add(9);
            ExcelUtil.hiddencolumns.add(10);
        }
        AjaxResult ajaxResult = util.exportExcel(list, "供需平衡-气量监管数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取供需平衡-气量监管详细信息
     */
    @GetMapping(value = "/{fGasSupId}")
    public AjaxResult getInfo(@PathVariable("fGasSupId") Long fGasSupId)
    {
        return AjaxResult.success(tSupBalGasSupService.selectTSupBalGasSupById(fGasSupId));
    }

    /**
     * 新增供需平衡-气量监管
     */
    @Log(title = "供需平衡-气量监管", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupBalGasSup tSupBalGasSup)
    {
        return toAjax(tSupBalGasSupService.insertTSupBalGasSup(tSupBalGasSup));
    }

    /**
     * 修改供需平衡-气量监管
     */
    @Log(title = "供需平衡-气量监管", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupBalGasSup tSupBalGasSup)
    {
        return toAjax(tSupBalGasSupService.updateTSupBalGasSup(tSupBalGasSup));
    }

    /**
     * 删除供需平衡-气量监管
     */
    @Log(title = "供需平衡-气量监管", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fGasSupIds}")
    public AjaxResult remove(@PathVariable Long[] fGasSupIds)
    {
        return toAjax(tSupBalGasSupService.deleteTSupBalGasSupByIds(fGasSupIds));
    }

    /**
     * 获取上报信息
     * @param companyId 企业id
     * @param calendarDate 上报时间
     * @return
     */
    @GetMapping(value = "/getReportInfoByCompany")
    public AjaxResult getReportInfoByCompany(@RequestParam(value="companyId")String companyId,@RequestParam(value="calendarDate")String calendarDate){
        return AjaxResult.success(tSupBalGasSupService.getReportInfoByCompany(companyId,calendarDate));
    }

    @GetMapping("/reportInfoList")
    public AjaxResult reportInfoList(TSupBalGasSup tSupBalGasSup){
        List<TSupBalGasSup> list = tSupBalGasSupService.selectTSupBalGasSupList(tSupBalGasSup);
        return AjaxResult.success(list);
    }

    /**
     * 上传气量监管记录
     * @param fGasSupId 监管记录主键
     * @return
     */
    @GetMapping("/reportSupBalGasSupRecInfo")
    public AjaxResult reportSupBalGasSupRecInfo(Long fGasSupId){
        try{
            return toAjax(tSupBalGasSupService.reportSupBalGasSupRecInfo(fGasSupId));
        }catch (Exception e){
            logger.error("上传气量监管记录接口异常=====",e);
            return AjaxResult.error("上传气量监管记录接口异常");
        }
    }
}
