package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsStaInfor;
import com.zehong.system.service.ITInsStaInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-隐患分类分级标准Controller
 * 
 * @author zehong
 * @date 2024-05-17
 */
@RestController
@RequestMapping("/supervision/hideType")
public class TInsStaInforController extends BaseController
{
    @Autowired
    private ITInsStaInforService tInsStaInforService;

    /**
     * 查询监督检查-隐患分类分级标准列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsStaInfor tInsStaInfor)
    {
        startPage();
        List<TInsStaInfor> list = tInsStaInforService.selectTInsStaInforList(tInsStaInfor);
        return getDataTable(list);
    }

    @GetMapping("/hiddenList")
    public AjaxResult hiddenList(TInsStaInfor tInsStaInfor){
        List<TInsStaInfor> list = tInsStaInforService.selectTInsStaInforList(tInsStaInfor);
        return AjaxResult.success(list);
    }

    /**
     * 导出监督检查-隐患分类分级标准列表
     */
    @Log(title = "监督检查-隐患分类分级标准", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsStaInfor tInsStaInfor)
    {
        List<TInsStaInfor> list = tInsStaInforService.selectTInsStaInforList(tInsStaInfor);
        ExcelUtil<TInsStaInfor> util = new ExcelUtil<TInsStaInfor>(TInsStaInfor.class);
        return util.exportExcel(list, "监督检查-隐患分类分级标准数据");
    }

    /**
     * 获取监督检查-隐患分类分级标准详细信息
     */
    @GetMapping(value = "/{fInsStaInforId}")
    public AjaxResult getInfo(@PathVariable("fInsStaInforId") Long fInsStaInforId)
    {
        return AjaxResult.success(tInsStaInforService.selectTInsStaInforById(fInsStaInforId));
    }

    /**
     * 新增监督检查-隐患分类分级标准
     */
    @Log(title = "监督检查-隐患分类分级标准", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsStaInfor tInsStaInfor)
    {
        return toAjax(tInsStaInforService.insertTInsStaInfor(tInsStaInfor));
    }

    /**
     * 修改监督检查-隐患分类分级标准
     */
    @Log(title = "监督检查-隐患分类分级标准", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsStaInfor tInsStaInfor)
    {
        return toAjax(tInsStaInforService.updateTInsStaInfor(tInsStaInfor));
    }

    /**
     * 删除监督检查-隐患分类分级标准
     */
    @Log(title = "监督检查-隐患分类分级标准", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsStaInforIds}")
    public AjaxResult remove(@PathVariable Long[] fInsStaInforIds)
    {
        return toAjax(tInsStaInforService.deleteTInsStaInforByIds(fInsStaInforIds));
    }
}
