package com.zehong.web.controller.supervise;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSpecialUser;
import com.zehong.system.service.ITSpecialUserService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 特殊用户管控Controller
 * 
 * @author zehong
 * @date 2026-02-02
 */
@RestController
@RequestMapping("/supervise/specialuser")
public class TSpecialUserController extends BaseController
{
    @Autowired
    private ITSpecialUserService tSpecialUserService;

    /**
     * 查询特殊用户管控列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSpecialUser tSpecialUser)
    {
        startPage();
        List<TSpecialUser> list = tSpecialUserService.selectTSpecialUserList(tSpecialUser);
        return getDataTable(list);
    }

    /**
     * 导出特殊用户管控列表
     */
    @Log(title = "特殊用户管控", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSpecialUser tSpecialUser)
    {
        List<TSpecialUser> list = tSpecialUserService.selectTSpecialUserList(tSpecialUser);
        ExcelUtil<TSpecialUser> util = new ExcelUtil<TSpecialUser>(TSpecialUser.class);
        return util.exportExcel(list, "特殊用户管控数据");
    }

    /**
     * 获取特殊用户管控详细信息
     */
    @GetMapping(value = "/{specialId}")
    public AjaxResult getInfo(@PathVariable("specialId") Long specialId)
    {
        return AjaxResult.success(tSpecialUserService.selectTSpecialUserById(specialId));
    }

    /**
     * 新增特殊用户管控
     */
    @Log(title = "特殊用户管控", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSpecialUser tSpecialUser)
    {
        return toAjax(tSpecialUserService.insertTSpecialUser(tSpecialUser));
    }

    /**
     * 修改特殊用户管控
     */
    @Log(title = "特殊用户管控", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSpecialUser tSpecialUser)
    {
        return toAjax(tSpecialUserService.updateTSpecialUser(tSpecialUser));
    }

    /**
     * 删除特殊用户管控
     */
    @Log(title = "特殊用户管控", businessType = BusinessType.DELETE)
	@DeleteMapping("/{specialIds}")
    public AjaxResult remove(@PathVariable Long[] specialIds)
    {
        return toAjax(tSpecialUserService.deleteTSpecialUserByIds(specialIds));
    }
}
