package com.zehong.web.controller.supervise;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.vo.Passmodel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TLinePatrolPerson;
import com.zehong.system.service.ITLinePatrolPersonService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

import javax.servlet.http.HttpServletRequest;

/**
 * 巡线人员管理Controller
 * 
 * @author zehong
 * @date 2023-09-13
 */
@RestController
@RequestMapping("/linePatrol/person")
public class TLinePatrolPersonController extends BaseController
{
    @Autowired
    private ITLinePatrolPersonService tLinePatrolPersonService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询巡线人员管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLinePatrolPerson tLinePatrolPerson)
    {
        startPage();
        if(!SecurityUtils.isAdmin(SecurityUtils.getLoginUser().getUser().getUserId())){
            tLinePatrolPerson.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        List<TLinePatrolPerson> list = tLinePatrolPersonService.selectTLinePatrolPersonList(tLinePatrolPerson);
        return getDataTable(list);
    }

    @GetMapping("/linePatrolPersonList")
    public AjaxResult linePatrolPersonList(TLinePatrolPerson tLinePatrolPerson){
        if(!SecurityUtils.isAdmin(SecurityUtils.getLoginUser().getUser().getUserId())){
            tLinePatrolPerson.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        List<TLinePatrolPerson> list = tLinePatrolPersonService.selectTLinePatrolPersonList(tLinePatrolPerson);
        return AjaxResult.success(list);
    }
    @GetMapping("/applist")
    public TableDataInfo applist(TLinePatrolPerson tLinePatrolPerson)
    {
        startPage();
        List<TLinePatrolPerson> list = tLinePatrolPersonService.appPersonList(tLinePatrolPerson);
        return getDataTable(list);
    }

    /**
     * 修改密码
     * @return
     */
    @PutMapping("/updatePwd")
    public AjaxResult updatePwd(@RequestBody Passmodel passmodel)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        String password = loginUser.getPassword();
        if (!SecurityUtils.matchesPassword(passmodel.getOldPassword(), password))
        {
            return AjaxResult.error("修改密码失败，旧密码错误");
        }
        if (SecurityUtils.matchesPassword(passmodel.getNewPassword(), password))
        {
            return AjaxResult.error("新密码不能与旧密码相同");
        }
        TLinePatrolPerson p = new TLinePatrolPerson();
        p.setPersonId(loginUser.getUser().getUserId());
        p.setPersonPassword(SecurityUtils.encryptPassword(passmodel.getNewPassword()));

        if (tLinePatrolPersonService.updateTLinePatrolPerson(p) > 0)
        {
            // 更新缓存用户密码
            loginUser.getUser().setPassword(SecurityUtils.encryptPassword(passmodel.getNewPassword()));
            tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error("修改密码异常，请联系管理员");
    }
    /**
     * 导出巡线人员管理列表
     */
    @Log(title = "巡线人员管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLinePatrolPerson tLinePatrolPerson)
    {
        List<TLinePatrolPerson> list = tLinePatrolPersonService.selectTLinePatrolPersonList(tLinePatrolPerson);
        ExcelUtil<TLinePatrolPerson> util = new ExcelUtil<TLinePatrolPerson>(TLinePatrolPerson.class);
        return util.exportExcel(list, "巡线人员管理数据");
    }

    /**
     * 获取巡线人员管理详细信息
     */
    @GetMapping(value = "/{personId}")
    public AjaxResult getInfo(@PathVariable("personId") Long personId)
    {
        return AjaxResult.success(tLinePatrolPersonService.selectTLinePatrolPersonById(personId));
    }
    @GetMapping(value = "/tokenUser")
    public AjaxResult getUserInfo(HttpServletRequest request)
    {
        LoginUser loginUser = tokenService.getLoginUser(request);
        Long personId = loginUser.getUser().getUserId();
        return AjaxResult.success(tLinePatrolPersonService.selectTLinePatrolPersonById(personId));
    }
    /**
     * 新增巡线人员管理
     */
    @Log(title = "巡线人员管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLinePatrolPerson tLinePatrolPerson)
    {
        //校验用户账号
        TLinePatrolPerson query = new TLinePatrolPerson();
        query.setPersonAccount(tLinePatrolPerson.getPersonAccount());
        List<TLinePatrolPerson> personList = tLinePatrolPersonService.selectTLinePatrolPersonList(query);
        if(!CollectionUtils.isEmpty(personList)){
            return AjaxResult.error("新增用户'" + tLinePatrolPerson.getPersonName() + "'失败，账号已存在");
        }
        tLinePatrolPerson.setPersonPassword(SecurityUtils.encryptPassword(tLinePatrolPerson.getPersonPassword()));
        return toAjax(tLinePatrolPersonService.insertTLinePatrolPerson(tLinePatrolPerson));
    }

    /**
     * 修改巡线人员管理
     */
    @Log(title = "巡线人员管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLinePatrolPerson tLinePatrolPerson)
    {
        return toAjax(tLinePatrolPersonService.updateTLinePatrolPerson(tLinePatrolPerson));
    }

    /**
     * 删除巡线人员管理
     */
    @Log(title = "巡线人员管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{personIds}")
    public AjaxResult remove(@PathVariable Long[] personIds)
    {
        return toAjax(tLinePatrolPersonService.deleteTLinePatrolPersonByIds(personIds));
    }
}
