package com.zehong.web.controller.supervise;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInspectReport;
import com.zehong.system.service.ITInspectReportService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 入户安检结果Controller
 * 
 * @author zehong
 * @date 2026-02-02
 */
@RestController
@RequestMapping("/supervise/report")
public class TInspectReportController extends BaseController
{
    @Autowired
    private ITInspectReportService tInspectReportService;

    /**
     * 查询入户安检结果列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInspectReport tInspectReport)
    {
        startPage();
        List<TInspectReport> list = tInspectReportService.selectTInspectReportList(tInspectReport);
        return getDataTable(list);
    }

    /**
     * 安检汇总列表
     */
    @GetMapping("/summarylist")
    public TableDataInfo summarylist(TInspectReport tInspectReport)
    {
        startPage();
        List<TInspectReport> list = tInspectReportService.selectTInspectSummaryList(tInspectReport);
        return getDataTable(list);
    }

    /**
     * 导出入户安检结果列表
     */
    @Log(title = "入户安检结果", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspectReport tInspectReport)
    {
        List<TInspectReport> list = tInspectReportService.selectTInspectReportList(tInspectReport);
        ExcelUtil<TInspectReport> util = new ExcelUtil<TInspectReport>(TInspectReport.class);
        return util.exportExcel(list, "入户安检结果数据");
    }

    /**
     * 获取入户安检结果详细信息
     */
    @GetMapping(value = "/{reportId}")
    public AjaxResult getInfo(@PathVariable("reportId") Long reportId)
    {
        return AjaxResult.success(tInspectReportService.selectTInspectReportById(reportId));
    }

    /**
     * 新增入户安检结果
     */
    @Log(title = "入户安检结果", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectReport tInspectReport)
    {
        return toAjax(tInspectReportService.insertTInspectReport(tInspectReport));
    }

    /**
     * 修改入户安检结果
     */
    @Log(title = "入户安检结果", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectReport tInspectReport)
    {
        return toAjax(tInspectReportService.updateTInspectReport(tInspectReport));
    }

    /**
     * 删除入户安检结果
     */
    @Log(title = "入户安检结果", businessType = BusinessType.DELETE)
	@DeleteMapping("/{reportIds}")
    public AjaxResult remove(@PathVariable Long[] reportIds)
    {
        return toAjax(tInspectReportService.deleteTInspectReportByIds(reportIds));
    }
}
