package com.zehong.web.controller.supervise;

import java.util.List;

import com.zehong.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmployedPeopleInfoError;
import com.zehong.system.service.ITEmployedPeopleInfoErrorService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 从业人员错误导入记录Controller
 * 
 * @author zehong
 * @date 2024-06-01
 */
@RestController
@RequestMapping("/supervise/error")
public class TEmployedPeopleInfoErrorController extends BaseController
{
    @Autowired
    private ITEmployedPeopleInfoErrorService tEmployedPeopleInfoErrorService;

    /**
     * 查询从业人员错误导入记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        startPage();
        List<TEmployedPeopleInfoError> list = tEmployedPeopleInfoErrorService.selectTEmployedPeopleInfoErrorList(tEmployedPeopleInfoError);
        return getDataTable(list);
    }

    /**
     * 导出从业人员错误导入记录列表
     */
    @Log(title = "从业人员错误导入记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        tEmployedPeopleInfoError.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserId() + "");
        List<TEmployedPeopleInfoError> list = tEmployedPeopleInfoErrorService.selectTEmployedPeopleInfoErrorList(tEmployedPeopleInfoError);
        ExcelUtil<TEmployedPeopleInfoError> util = new ExcelUtil<TEmployedPeopleInfoError>(TEmployedPeopleInfoError.class);
        return util.exportExcel(list, "从业人员错误导入记录数据");
    }

    /**
     * 导出从业人员错误导入记录列表
     */
    @Log(title = "从业人员错误导入记录", businessType = BusinessType.EXPORT)
    @GetMapping("/clearImportError")
    public AjaxResult clearImportError()
    {
        return AjaxResult.success(tEmployedPeopleInfoErrorService.clearImportError());
    }

    /**
     * 获取从业人员错误导入记录详细信息
     */
    @GetMapping(value = "/{employedPeopleErrorId}")
    public AjaxResult getInfo(@PathVariable("employedPeopleErrorId") Long employedPeopleErrorId)
    {
        return AjaxResult.success(tEmployedPeopleInfoErrorService.selectTEmployedPeopleInfoErrorById(employedPeopleErrorId));
    }

    /**
     * 新增从业人员错误导入记录
     */
    @Log(title = "从业人员错误导入记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        return toAjax(tEmployedPeopleInfoErrorService.insertTEmployedPeopleInfoError(tEmployedPeopleInfoError));
    }

    /**
     * 修改从业人员错误导入记录
     */
    @Log(title = "从业人员错误导入记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        return toAjax(tEmployedPeopleInfoErrorService.updateTEmployedPeopleInfoError(tEmployedPeopleInfoError));
    }

    /**
     * 删除从业人员错误导入记录
     */
    @Log(title = "从业人员错误导入记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{employedPeopleErrorIds}")
    public AjaxResult remove(@PathVariable Long[] employedPeopleErrorIds)
    {
        return toAjax(tEmployedPeopleInfoErrorService.deleteTEmployedPeopleInfoErrorByIds(employedPeopleErrorIds));
    }
}
