package com.zehong.web.controller.supervise;
import java.io.File;
import java.text.ParseException;
import java.util.List;
import com.zehong.common.config.GassafetyProgressConfig;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TEmployedPeopleInfoError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmployedPeopleInfo;
import com.zehong.system.service.ITEmployedPeopleInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;


/**
 * 从业人员信息Controller
 *
 * @author zehong
 * @date 2022-01-25
 */
@RestController
@RequestMapping("/regulation/supervise")
public class TEmployedPeopleInfoController extends BaseController
{
    @Autowired
    private ITEmployedPeopleInfoService tEmployedPeopleInfoService;

    /**
     * 查询从业人员信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tEmployedPeopleInfo.setBeyondEnterpriseId(user.getDeptId());
        startPage();
        List<TEmployedPeopleInfo> list = tEmployedPeopleInfoService.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
        return getDataTable(list);
    }

    @GetMapping("/employedPeoplesList")
    public TableDataInfo employedPeoplesList(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        startPage();
        List<TEmployedPeopleInfo> list = tEmployedPeopleInfoService.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
        return getDataTable(list);
    }

    /**
     * 导出从业人员信息列表
     */
    @Log(title = "从业人员信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tEmployedPeopleInfo.setBeyondEnterpriseId(user.getDeptId());
        List<TEmployedPeopleInfo> list = tEmployedPeopleInfoService.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
        ExcelUtil<TEmployedPeopleInfo> util = new ExcelUtil<TEmployedPeopleInfo>(TEmployedPeopleInfo.class);
        return util.exportExcel(list, "从业人员信息数据");
    }

    /**
     * 获取从业人员信息详细信息
     */
    @GetMapping(value = "/{employedPeopleId}")
    public AjaxResult getInfo(@PathVariable("employedPeopleId") Long employedPeopleId) throws ParseException {
        TEmployedPeopleInfo tEmployedPeopleInfo = tEmployedPeopleInfoService.selectTEmployedPeopleInfoById(employedPeopleId);
        return AjaxResult.success(tEmployedPeopleInfo);
    }

    /**
     * 新增从业人员信息
     */
    @Log(title = "从业人员信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmployedPeopleInfo tEmployedPeopleInfo) throws ParseException {
     //根据企业id查询企业名称
     String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tEmployedPeopleInfo.getBeyondEnterpriseId());
     tEmployedPeopleInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tEmployedPeopleInfoService.insertTEmployedPeopleInfo(tEmployedPeopleInfo));
     }

     /**
     * 修改从业人员信息
     */
    @Log(title = "从业人员信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmployedPeopleInfo tEmployedPeopleInfo) throws ParseException {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tEmployedPeopleInfo.getBeyondEnterpriseId());
        tEmployedPeopleInfo.setBeyondEnterpriseName(EnterpriseName);
        //查询修改之前图片存储路径
        TEmployedPeopleInfo tEmployedPeopleInfos = tEmployedPeopleInfoService.selectTEmployedPeopleInfoById(tEmployedPeopleInfo.getEmployedPeopleId());
        //文件删除
        if (tEmployedPeopleInfos.getAvatarAddress()!=null){
            // 上传文件路径
            String filePath = GassafetyProgressConfig.getUploadPath();
            String[] strs = tEmployedPeopleInfos.getAvatarAddress().split("upload");
            //删除图片
            File file = new File(filePath+strs[1].toString());
            // 上传文件路径
            if(file.isFile()){
                file.delete();
            }
        }
        return toAjax(tEmployedPeopleInfoService.updateTEmployedPeopleInfo(tEmployedPeopleInfo));
    }

    /**
     * 删除从业人员信息
     */
    @Log(title = "从业人员信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{employedPeopleIds}")
    public AjaxResult remove(@PathVariable Long[] employedPeopleIds)
    {
        return toAjax(tEmployedPeopleInfoService.deleteTEmployedPeopleInfoByIds(employedPeopleIds));
    }

    /**
     * 企业信息查询(下拉框)
     */
    @Log(title = "企业信息查询")
    @RequestMapping("/selectTEnterprise")
    public AjaxResult select(){
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        return AjaxResult.success(tEmployedPeopleInfoService.selectTEnterprise(user.getDeptId()));
    }

    /**
     * 文件导入
     * @param file
     * @param updateSupport
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport, HttpServletResponse response) throws Exception
    {
        ExcelUtil<TEmployedPeopleInfoError> util = new ExcelUtil<>(TEmployedPeopleInfoError.class);
        List<TEmployedPeopleInfoError> XmbhList = util.importExcel(file.getInputStream());
        String operName = SecurityUtils.getLoginUser().getUsername();
        String message = tEmployedPeopleInfoService.importEmployedPeopleInfo(XmbhList, updateSupport, operName,response);
        return AjaxResult.success(message);
    }


    /**
     * 模版下载
     * @return
     */
    @GetMapping("/importTemplate")
    public AjaxResult importTemplate()
    {
        ExcelUtil<TEmployedPeopleInfo> util = new ExcelUtil<>(TEmployedPeopleInfo.class);
        return util.importTemplateExcel("从业人员数据");
    }


    /**
     * 查询当前用户导入 从业人员的错误数据总数
     * @return
     */
    @GetMapping("/countImportError")
    public AjaxResult countImportError()
    {
        int i = tEmployedPeopleInfoService.countImportError();
        return AjaxResult.success(i);
    }


    /**
     * 查询当前用户导入 从业人员的错误数据总数
     * @return
     */
    @GetMapping("/queryPeopleOccupationByGroupBy")
    public AjaxResult queryPeopleOccupationByGroupBy()
    {
        List<String> strings = tEmployedPeopleInfoService.queryPeopleOccupationByGroupBy();
        return AjaxResult.success(strings);
    }
}
