package com.zehong.web.controller.supervise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.ResultEnum;
import com.zehong.common.exception.IOCException;
import com.zehong.system.domain.TDetectorInfo;
import com.zehong.system.domain.TDetectorReportData;
import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TDeviceUser;
import com.zehong.system.domain.dto.TDetectorInfoDTO;
import com.zehong.system.domain.form.TDetectorReportDataForm;
import com.zehong.system.domain.vo.TDetectorUserVO;
import com.zehong.system.service.*;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 泽宏云数据推送Controller
 *
 */
@RestController
@RequestMapping("/detector/detectorReport")
@Slf4j
public class TDetectorReportController extends BaseController
{
    @Autowired
    private ITDetectorInfoService tDetectorInfoService;
    @Autowired
    private ITDetectorUserService tDetectorUserService;
    @Autowired
    private ITDetectorReportDataService tDetectorReportDataService;
    @Autowired
    private WebSocketServer webSocketServer;
    @Autowired
    private ITDeviceUserService itDeviceUserService;

    @ApiOperation(value = "泽宏报警器信息推送接口")
    @PostMapping("/reportTDetectorInfoData")
    public AjaxResult reportTDetectorInfoData(@RequestBody String param) throws IOException {
        log.info(param);

        JSONObject object = JSONObject.parseObject(param);
        String operateType = object.getString("operateType");
        String data = object.getString("data");

        JSONArray arr = JSONArray.parseArray(data);
        List<TDetectorInfo> list = new ArrayList<TDetectorInfo>();
        String username = "";
        String deviceName = "";
        String deviceNo = "";
        String deviceType = "";
        String medium = "";
        String address = "";
        String longitude = "";
        String latitude = "";
        String contacts = "";
        String telephone = "";

        if("1".equals(operateType)){  // 新增操作
            for(int i=0; i<arr.size(); i++){
                JSONObject obj = arr.getJSONObject(i);
                username = obj.getString("username");
                deviceName = obj.getString("deviceName");
                deviceNo = obj.getString("deviceNo");
                deviceType = obj.getString("deviceType");
                medium = obj.getString("medium");
                address = obj.getString("address");
                longitude = obj.getString("longitude");
                latitude = obj.getString("latitude");
                contacts = obj.getString("contacts");
                telephone = obj.getString("telephone");

//                MapResourcesInfoExample example = new MapResourcesInfoExample();
//                example.createCriteria().andFullNameEqualTo(username).andIsEnableEqualTo("0");
//                List<MapResourcesInfo> mapResourcesList = mapResourcesService.selectByExample(example);
                TDetectorUser tDetectorUser = new TDetectorUser();
                tDetectorUser.setNickName(username);
                tDetectorUser.setIsDel("0");
                List<TDetectorUser> tDetectorUserList = tDetectorUserService.selectTDetectorUser(tDetectorUser);
                if(tDetectorUserList.size() == 0){
                    return AjaxResult.error(1,"查询不到用户名username=" + username);
                }

                TDetectorInfo tDetectorInfo = new TDetectorInfo();
                tDetectorInfo.setUserId(tDetectorUserList.get(0).getUserId());
                tDetectorInfo.setDetectorName(deviceName);
                tDetectorInfo.setDetectorCode(deviceNo);
                tDetectorInfo.setDetectorType(deviceType);
                if(!"".equals(medium)){
                    tDetectorInfo.setMedium(medium);
                }
                if(!"".equals(address)) {
                    tDetectorInfo.setDetectorAddr(address);
                }
                if(!"".equals(longitude)){
                    tDetectorInfo.setLongitude(new BigDecimal(longitude));
                }
                if(!"".equals(latitude)){
                    tDetectorInfo.setLatitude(new BigDecimal(latitude));
                }
                if(!"".equals(contacts)) {
                    tDetectorInfo.setLinkman(contacts);
                }
                if(!"".equals(telephone)) {
                    tDetectorInfo.setPhone(telephone);
                }

                // 如果该设备编号已存在，则执行修改
//                TDetectorInfoExample deviceInfoExample = new TDetectorInfoExample();
//                MapResourcesInfo mapResourcesInfo = mapResourcesList.get(0);
//                deviceInfoExample.createCriteria().andDetectorNoEqualTo(deviceNo)
//                        .andEnterpriseIdEqualTo(mapResourcesInfo.getResourceNo()).andIsEnableEqualTo("0");
                TDetectorInfo detector = new TDetectorInfo();
                detector.setDetectorCode(deviceNo);
                detector.setIsDel("0");
                List<TDetectorInfo> detectorList = tDetectorInfoService.selectTDetectorInfoList(detector);
                if(detectorList.size() > 0){
                    tDetectorInfo.setDetectorId(detectorList.get(0).getDetectorId());
                    tDetectorInfo.setUpdateTime(new Date());
                    tDetectorInfoService.updateTDetectorInfo(tDetectorInfo);
                    continue;
                }

                tDetectorInfo.setCreateTime(new Date());
                list.add(tDetectorInfo);
            }
            if(list.size() > 0) {
                tDetectorInfoService.insertBatch(list);
            }
        } else if ("2".equals(operateType)) { // 修改操作
            List<String> errList = new ArrayList<>();

            for(int i=0; i<arr.size(); i++){
                JSONObject obj = arr.getJSONObject(i);
                username = obj.getString("username");
                deviceName = obj.getString("deviceName");
                deviceNo = obj.getString("deviceNo");
                deviceType = obj.getString("deviceType");
                medium = obj.getString("medium");
                address = obj.getString("address");
                longitude = obj.getString("longitude");
                latitude = obj.getString("latitude");
                contacts = obj.getString("contacts");
                telephone = obj.getString("telephone");

                TDetectorInfo tDetectorInfo = new TDetectorInfo();
                tDetectorInfo.setDetectorCode(deviceNo);

//                MapResourcesInfoExample example = new MapResourcesInfoExample();
//                example.createCriteria().andFullNameEqualTo(username).andIsEnableEqualTo("0");
//                List<MapResourcesInfo> mapResourcesList = mapResourcesService.selectByExample(example);
                TDetectorUser tDetectorUser = new TDetectorUser();
                tDetectorUser.setNickName(username);
                tDetectorUser.setIsDel("0");
                List<TDetectorUser> tDetectorUserList = tDetectorUserService.selectTDetectorUser(tDetectorUser);
                if(tDetectorUserList.size() == 0){
                    return AjaxResult.error(1,"查询不到用户名username=" + username);
                }

                // 设备编号不存在执行的操作
                TDetectorInfo detector = new TDetectorInfo();
                detector.setDetectorCode(deviceNo);
                detector.setIsDel("0");
                List<TDetectorInfo> detectorList = tDetectorInfoService.selectTDetectorInfoList(detector);
                if(detectorList.size() == 0){
                    errList.add(deviceNo);
                    continue;
                }

                if(!"".equals(deviceType)) {
                    tDetectorInfo.setDetectorType(deviceType);
                }
                if(!"".equals(deviceName)) {
                    tDetectorInfo.setDetectorName(deviceName);
                }
                if(!"".equals(medium)) {
                    tDetectorInfo.setMedium(medium);
                }
                if(!"".equals(address)) {
                    tDetectorInfo.setDetectorAddr(address);
                }
                if(!"".equals(longitude)){
                    tDetectorInfo.setLongitude(new BigDecimal(longitude));
                }
                if(!"".equals(latitude)){
                    tDetectorInfo.setLatitude(new BigDecimal(latitude));
                }
                if(!"".equals(contacts)) {
                    tDetectorInfo.setLinkman(contacts);
                }
                if(!"".equals(telephone)) {
                    tDetectorInfo.setPhone(telephone);
                }
                tDetectorInfo.setUpdateTime(new Date());

                list.add(tDetectorInfo);
            }
            if(errList.size() > 0){
                return AjaxResult.error(3,"设备不存在" + errList);
            }
            tDetectorInfoService.updateBatch(list);
        } else if ("3".equals(operateType)) { // 删除操作
            for(int i=0; i<arr.size(); i++){
                JSONObject obj = arr.getJSONObject(i);
                deviceNo = obj.get("deviceNo").toString();
                username = obj.getString("username");

                //用户不存在无操作
                TDetectorUser tDetectorUser = new TDetectorUser();
                tDetectorUser.setNickName(username);
                tDetectorUser.setIsDel("0");
                List<TDetectorUser> tDetectorUserList = tDetectorUserService.selectTDetectorUser(tDetectorUser);
                if(tDetectorUserList.size() == 0){
                    continue;
                }

                //设备编号不存在无操作
                TDetectorInfo detector = new TDetectorInfo();
                detector.setDetectorCode(deviceNo);
                detector.setIsDel("0");
                List<TDetectorInfo> detectorList = tDetectorInfoService.selectTDetectorInfoList(detector);
                if(detectorList.size() == 0){
                    continue;
                }

                TDetectorInfo tDetectorInfo = new TDetectorInfo();

                tDetectorInfo.setDetectorCode(deviceNo);
                tDetectorInfo.setIsDel("1");
                tDetectorInfo.setUpdateTime(new Date());

                list.add(tDetectorInfo);
            }
            if(list.size() > 0) {
                tDetectorInfoService.updateBatch(list);
            }
        } else if ("4".equals(operateType)) {  // 批量转移操作
            List<String> errList = new ArrayList<>();
            String sourceUsername = "";
            String targetUsername = "";
            for(int i=0; i<arr.size(); i++){
                JSONObject obj = arr.getJSONObject(i);
                deviceNo = obj.getString("deviceNo");
                sourceUsername = obj.getString("sourceUsername");
                targetUsername = obj.getString("targetUsername");

                TDetectorInfo tDetectorInfo = new TDetectorInfo();
                tDetectorInfo.setDetectorCode(deviceNo);

                TDetectorUser tDetectorUser1 = new TDetectorUser();
                tDetectorUser1.setNickName(sourceUsername);
                tDetectorUser1.setIsDel("0");
                List<TDetectorUser> tDetectorUserList1 = tDetectorUserService.selectTDetectorUser(tDetectorUser1);
                if(tDetectorUserList1.size() == 0){
                    return AjaxResult.error(4,"查询不到原用户名sourceUsername=" + sourceUsername);
                }

                TDetectorUser tDetectorUser2 = new TDetectorUser();
                tDetectorUser2.setNickName(targetUsername);
                tDetectorUser2.setIsDel("0");
                List<TDetectorUser> tDetectorUserList2 = tDetectorUserService.selectTDetectorUser(tDetectorUser2);
                if(tDetectorUserList2.size() == 0){
                    return AjaxResult.error(5,"查询不到目标用户名targetUsername=" + targetUsername);
                }

                tDetectorInfo.setUserId(tDetectorUserList2.get(0).getUserId());

                TDetectorInfo detector = new TDetectorInfo();
                detector.setDetectorCode(deviceNo);
                detector.setIsDel("0");
                List<TDetectorInfo> detectorList = tDetectorInfoService.selectTDetectorInfoList(detector);
                if(detectorList.size() == 0){
                    errList.add(deviceNo);
                    continue;
                }

                tDetectorInfo.setUpdateTime(new Date());
                list.add(tDetectorInfo);
            }

            if(errList.size() > 0){
                return AjaxResult.error(3,"设备不存在" + errList);
            }

            tDetectorInfoService.updateBatch(list);
        }

        return AjaxResult.success();
    }

//    @ApiOperation(value = "泽宏报警器更新数据推送接口")
//    @PostMapping("/reportZHDeviceStatus")
//    public AjaxResult reportZHDeviceStatus(@RequestBody List<TDetectorInfoDTO> tDetectorInfoDTOList){
//
//        log.info(tDetectorInfoDTOList.toString());
//
//        List<TDetectorInfo> list = new ArrayList<>();
//
//        try {
//            for(TDetectorInfoDTO dto : tDetectorInfoDTOList){
//                TDetectorInfo tDetectorInfo = new TDetectorInfo();
//                tDetectorInfo.setDetectorCode(dto.getDeviceCode());
//
//                // 1探测器
//                if(!StringUtils.isEmpty(dto.getDeviceType()) && dto.getDeviceType().equals("1")) {
//                    if (!StringUtils.isEmpty(dto.getDeviceStatus()) && dto.getDeviceStatus().equals("1")) {
//                        tDetectorInfo.setDetectorStatus("0");
//                        tDetectorInfo.setAlarmTime(null);
//                    } else if (new ArrayList<String>(Arrays.asList("7", "9")).contains(dto.getDeviceStatus())) {
//                        tDetectorInfo.setDetectorStatus("1");
//                        tDetectorInfo.setAlarmTime(dto.getAlarmTime());
//                    } else {
//                        tDetectorInfo.setDetectorStatus("2");
//                        tDetectorInfo.setAlarmTime(dto.getAlarmTime());
//                    }
//                    tDetectorInfo.setUpdateTime(new Date());
//                }
//
//                list.add(tDetectorInfo);
//            }
//
//            tDetectorInfoService.updateBatch(list);
//        } catch (Exception e) {
//            e.printStackTrace();
//            log.error("【泽宏设备状态】操作出错,error={}",e.getMessage());
//            throw new IOCException(ResultEnum.OPERATION_FAIL);
//        }
//
//        return AjaxResult.success();
//    }

    @ApiOperation(value = "泽宏设备预警数据推送接口")
    @PostMapping("/reportZHDeviceAlarmData")
    public AjaxResult reportZHDeviceAlarmData(@Valid @RequestBody TDetectorReportDataForm tDetectorReportDataForm, BindingResult bindingResult){
        if(bindingResult.hasErrors()){
            log.error("【新增泽宏设备上报数据】参数不正确,zhDeviceReportDataForm={}",tDetectorReportDataForm);
            throw new IOCException(ResultEnum.PARAM_ERROR.getCode(),bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("泽宏设备上报数据===="+tDetectorReportDataForm.toString());

        // 查询设备编号，is_del是0
        TDetectorInfo detector = tDetectorInfoService.selectTDetectorInfoByCode(tDetectorReportDataForm.getDeviceNo());
        if(detector == null){
            throw new IOCException(ResultEnum.DETECTOR_NOEXIST);
        }
        try {

            boolean flag = true;

            if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("1") && !StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && new ArrayList<String>(Arrays.asList("7","9")).contains((tDetectorReportDataForm.getDeviceStatusId()))){
                flag = false;
            }
            //7,9通信故障不处理
            if(flag){

                TDetectorInfo tDetectorInfo = new TDetectorInfo();
                tDetectorInfo.setDetectorCode(tDetectorReportDataForm.getDeviceNo());

                List<TDetectorInfo> tDetectorInfoList = tDetectorInfoService.selectTDetectorInfoList(tDetectorInfo);
                if(tDetectorInfoList.size() > 0){

                    //报警设备类型，1探测器，2智慧用电  E+原始类型
                    if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("1") && !StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && !tDetectorReportDataForm.getDeviceStatusId().equals("1")){
                        List<TDetectorReportData> reportDataList = tDetectorReportDataService.selectTDetectorReportDataByCode(tDetectorReportDataForm.getDeviceNo());

                        // 有未消警的数据
                        if(reportDataList.size()>0){
                            // 对比未消警数据与新推送数据的状态
                            ///if(!reportDataList.get(0).getDetectorStatusId().equals(tDetectorReportDataForm.getDeviceStatusId())) {
                                TDetectorReportData temp = reportDataList.get(0);
                                temp.setIsCancelAlarm("1");
                                temp.setCancelTime(new Date());
                                tDetectorReportDataService.updateTDetectorReportData(temp);

                                TDetectorReportData datas = new TDetectorReportData();
                                datas.setSourceId(tDetectorReportDataForm.getSourceId());
                                datas.setDetectorCode(tDetectorReportDataForm.getDeviceNo());
                                datas.setDetectorStatusId(tDetectorReportDataForm.getDeviceStatusId());
                                datas.setStatusName(tDetectorReportDataForm.getStatusName());
                                datas.setReportValue(StringUtils.isEmpty(tDetectorReportDataForm.getReportValue()) ? null : Float.parseFloat(tDetectorReportDataForm.getReportValue()));
                                datas.setZhHostStatusId(StringUtils.isEmpty(tDetectorReportDataForm.getZhHostStatusId()) ? null : Integer.parseInt(tDetectorReportDataForm.getZhHostStatusId()));
                                datas.setSignalStrength(StringUtils.isEmpty(tDetectorReportDataForm.getSignalStrength()) ? null : Integer.parseInt(tDetectorReportDataForm.getSignalStrength()));
                                datas.setNetPoint(StringUtils.isEmpty(tDetectorReportDataForm.getNetPoint()) ? null : Integer.parseInt(tDetectorReportDataForm.getNetPoint()));
                                datas.setIpAddress(StringUtils.isEmpty(tDetectorReportDataForm.getIpAddress()) ? null : tDetectorReportDataForm.getIpAddress());
                                datas.setCreateTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime()) ? null : new Date());

                                tDetectorReportDataService.insertTDetectorReportData(datas);
                                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                datas.setAlarmTime(dateFormat.format(datas.getCreateTime()));
                                //webSocketServer.batchSendMessage(JSONObject.toJSONString("success"));
                                TDetectorInfo info = tDetectorInfoService.selectTDetectorInfoByCode(datas.getDetectorCode());
                                datas.setDetectorType(info.getDetectorType());
                                webSocketServer.batchSendMessage(JSONObject.toJSONString(datas));
                            //}

                        } else {
                            TDetectorReportData datas = new TDetectorReportData();
                            datas.setSourceId(tDetectorReportDataForm.getSourceId());
                            datas.setDetectorCode(tDetectorReportDataForm.getDeviceNo());
                            datas.setDetectorStatusId(tDetectorReportDataForm.getDeviceStatusId());
                            datas.setStatusName(tDetectorReportDataForm.getStatusName());
                            datas.setReportValue(StringUtils.isEmpty(tDetectorReportDataForm.getReportValue()) ? null : Float.parseFloat(tDetectorReportDataForm.getReportValue()));
                            datas.setZhHostStatusId(StringUtils.isEmpty(tDetectorReportDataForm.getZhHostStatusId()) ? null : Integer.parseInt(tDetectorReportDataForm.getZhHostStatusId()));
                            datas.setSignalStrength(StringUtils.isEmpty(tDetectorReportDataForm.getSignalStrength()) ? null : Integer.parseInt(tDetectorReportDataForm.getSignalStrength()));
                            datas.setNetPoint(StringUtils.isEmpty(tDetectorReportDataForm.getNetPoint()) ? null : Integer.parseInt(tDetectorReportDataForm.getNetPoint()));
                            datas.setIpAddress(StringUtils.isEmpty(tDetectorReportDataForm.getIpAddress()) ? null : tDetectorReportDataForm.getIpAddress());
                            datas.setCreateTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime()) ? null : new Date());

                            tDetectorReportDataService.insertTDetectorReportData(datas);
                            //webSocketServer.batchSendMessage(JSONObject.toJSONString("success"));
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            datas.setAlarmTime(dateFormat.format(datas.getCreateTime()));
                            TDetectorInfo info = tDetectorInfoService.selectTDetectorInfoByCode(datas.getDetectorCode());
                            datas.setDetectorType(info.getDetectorType());
                            webSocketServer.batchSendMessage(JSONObject.toJSONString(datas));
                        }
                    }
//                    else if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("2") && !StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && !tDetectorReportDataForm.getDeviceStatusId().equals("E")){
//                        TDetectorReportData datas = new TDetectorReportData();
//                        datas.setSourceId(tDetectorReportDataForm.getSourceId());
//                        datas.setDetectorCode(tDetectorReportDataForm.getDeviceNo());
//
//                        //设备类型，1家用报警器，2工业探测器
//                        datas.setDetectorStatus(StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId())?null:"E"+tDetectorReportDataForm.getDeviceStatusId());
//                        datas.setReportValue(StringUtils.isEmpty(tDetectorReportDataForm.getReportValue())?null:Float.parseFloat(tDetectorReportDataForm.getReportValue()));
//                        datas.setZhHostStatusId(StringUtils.isEmpty(tDetectorReportDataForm.getZhHostStatusId())?null:Integer.parseInt(tDetectorReportDataForm.getZhHostStatusId()));
//                        datas.setSignalStrength(StringUtils.isEmpty(tDetectorReportDataForm.getSignalStrength())?null:Integer.parseInt(tDetectorReportDataForm.getSignalStrength()));
//                        datas.setNetPoint(StringUtils.isEmpty(tDetectorReportDataForm.getNetPoint())?null:Integer.parseInt(tDetectorReportDataForm.getNetPoint()));
//                        datas.setIpAddress(StringUtils.isEmpty(tDetectorReportDataForm.getIpAddress())?null:tDetectorReportDataForm.getIpAddress());
//                        datas.setCreateTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime())?null:new Date());
//
//                        tDetectorReportDataService.insertTDetectorReportData(datas);
//                    }

                    //设备状态更新
                    TDetectorInfo detectorInfo = new TDetectorInfo();
                    detectorInfo.setDetectorId(tDetectorInfoList.get(0).getDetectorId());
                    // 探测器 推送数据（1正常，7、9离线，其他值预警）   用电推送数据（E正常，其他都为报警值）用电手动消警 用 E 代表
                    if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && "1".equals((tDetectorReportDataForm.getDeviceStatusId()))){
                        detectorInfo.setDetectorStatus("0"); // 设备表状态 0正常，1故障（掉线）
                        detectorInfo.setAlarmTime(null);
                        detectorInfo.setUpdateTime(new Date());
                    }else{
                        if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("1")){
                            if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && new ArrayList<String>(Arrays.asList("7","9")).contains((tDetectorReportDataForm.getDeviceStatusId()))){
                                detectorInfo.setDetectorStatus("1");
                            }else{
                                detectorInfo.setDetectorStatus("2");
                            }
                        }
//                        else{
//                            detectorInfo.setDetectorStatus("2");
//                        }
                        detectorInfo.setAlarmTime(tDetectorReportDataForm.getCreateTime());
                        detectorInfo.setUpdateTime(new Date());
                    }

                    tDetectorInfoService.updateTDetectorInfo(detectorInfo);


                    //消警处理
                    if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && "1".equals((tDetectorReportDataForm.getDeviceStatusId()))){
//                        ZHDeviceReportDatasExample zhDeviceReportDatasExample = new ZHDeviceReportDatasExample();
//                        zhDeviceReportDatasExample.createCriteria().andDeviceNoEqualTo(tDetectorReportDataForm.getDeviceNo());
//                        zhDeviceReportDatasExample.setOrderByClause(" create_time DESC LIMIT 1");
//
//                        List<ZHDeviceReportDatas> dataList = zHDeviceReportDataService.selectByExample(zhDeviceReportDatasExample);

                        // 查询该设备所有未消警的数据
                        List<TDetectorReportData> dataList = tDetectorReportDataService.selectTDetectorReportDataByCode(tDetectorReportDataForm.getDeviceNo());
                        if(dataList.size() > 0){
                            for(TDetectorReportData data : dataList) {
                                data.setIsCancelAlarm("1"); // 1自动消警
                                data.setCancelTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime()) ? null : new Date());
                                tDetectorReportDataService.updateTDetectorReportData(data);
                            }
                        }

                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("【新增泽宏设备上报数据】操作出错,error={},zhDeviceReportDataForm={}",e.getMessage(),tDetectorReportDataForm);
            throw new IOCException(ResultEnum.OPERATION_FAIL);
        }

        return AjaxResult.success();
    }
    @ApiOperation(value = "泽宏设备预警数据推送接口")
    @PostMapping("/reportDeviceAlarmData")
    public AjaxResult reportDeviceAlarmData(@Valid @RequestBody TDetectorReportDataForm tDetectorReportDataForm, BindingResult bindingResult){
        if(bindingResult.hasErrors()){
            log.error("【新增泽宏设备上报数据】参数不正确,zhDeviceReportDataForm={}",tDetectorReportDataForm);
            throw new IOCException(ResultEnum.PARAM_ERROR.getCode(),bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("泽宏设备上报数据===="+tDetectorReportDataForm.toString());

        // 查询设备编号，is_del是0
        TDeviceUser deviceUser = itDeviceUserService.selectTDeviceUserByCode(tDetectorReportDataForm.getDeviceNo());
        if(deviceUser == null){
            log.error("探测器编号不存在:"+tDetectorReportDataForm.getDeviceNo());
            return null;
            //throw new IOCException(ResultEnum.DETECTOR_NOEXIST);
        }
        try {

            boolean flag = true;

            if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("1") && !StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && new ArrayList<String>(Arrays.asList("7","9")).contains((tDetectorReportDataForm.getDeviceStatusId()))){
                flag = false;
            }

            //7,9通信故障不处理
            if(flag){

//                TDetectorInfo tDetectorInfo = new TDetectorInfo();
//                tDetectorInfo.setDetectorCode(tDetectorReportDataForm.getDeviceNo());

//                List<TDetectorInfo> tDetectorInfoList = tDetectorInfoService.selectTDetectorInfoList(tDetectorInfo);
                //List<TDeviceUser> tDeviceUserList = tDetectorUserService.selectTDetectorUserList()
                //if(tDetectorInfoList.size() > 0){

                    //报警设备类型，1探测器，2智慧用电  E+原始类型
                    if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("1") && !StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && !tDetectorReportDataForm.getDeviceStatusId().equals("1")){
                        List<TDetectorReportData> reportDataList = tDetectorReportDataService.selectTDetectorReportDataByCode(tDetectorReportDataForm.getDeviceNo());

                        // 有未消警的数据
                        if(reportDataList.size()>0){
                            // 对比未消警数据与新推送数据的状态
                            if(!reportDataList.get(0).getDetectorStatusId().equals(tDetectorReportDataForm.getDeviceStatusId())) {
                                TDetectorReportData temp = reportDataList.get(0);
                                temp.setIsCancelAlarm("1");
                                temp.setCancelTime(new Date());
                                tDetectorReportDataService.updateTDetectorReportData(temp);

                                TDetectorReportData datas = new TDetectorReportData();
                                datas.setSourceId(tDetectorReportDataForm.getSourceId());
                                datas.setDetectorCode(tDetectorReportDataForm.getDeviceNo());
                                datas.setDetectorStatusId(tDetectorReportDataForm.getDeviceStatusId());
                                datas.setStatusName(tDetectorReportDataForm.getStatusName());
                                datas.setReportValue(StringUtils.isEmpty(tDetectorReportDataForm.getReportValue()) ? null : Float.parseFloat(tDetectorReportDataForm.getReportValue()));
                                datas.setZhHostStatusId(StringUtils.isEmpty(tDetectorReportDataForm.getZhHostStatusId()) ? null : Integer.parseInt(tDetectorReportDataForm.getZhHostStatusId()));
                                datas.setSignalStrength(StringUtils.isEmpty(tDetectorReportDataForm.getSignalStrength()) ? null : Integer.parseInt(tDetectorReportDataForm.getSignalStrength()));
                                datas.setNetPoint(StringUtils.isEmpty(tDetectorReportDataForm.getNetPoint()) ? null : Integer.parseInt(tDetectorReportDataForm.getNetPoint()));
                                datas.setIpAddress(StringUtils.isEmpty(tDetectorReportDataForm.getIpAddress()) ? null : tDetectorReportDataForm.getIpAddress());
                                datas.setCreateTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime()) ? null : new Date());

                                tDetectorReportDataService.insertTDetectorReportData(datas);
                                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                datas.setAlarmTime(dateFormat.format(datas.getCreateTime()));
                                //webSocketServer.batchSendMessage(JSONObject.toJSONString("success"));
//                                TDetectorInfo info = tDetectorInfoService.selectTDetectorInfoByCode(datas.getDetectorCode());
//                                datas.setDetectorType(info.getDetectorType());
                                webSocketServer.batchSendMessage(JSONObject.toJSONString(datas));
                            }

                        } else {
                            TDetectorReportData datas = new TDetectorReportData();
                            datas.setSourceId(tDetectorReportDataForm.getSourceId());
                            datas.setDetectorCode(tDetectorReportDataForm.getDeviceNo());
                            datas.setDetectorStatusId(tDetectorReportDataForm.getDeviceStatusId());
                            datas.setStatusName(tDetectorReportDataForm.getStatusName());
                            datas.setReportValue(StringUtils.isEmpty(tDetectorReportDataForm.getReportValue()) ? null : Float.parseFloat(tDetectorReportDataForm.getReportValue()));
                            datas.setZhHostStatusId(StringUtils.isEmpty(tDetectorReportDataForm.getZhHostStatusId()) ? null : Integer.parseInt(tDetectorReportDataForm.getZhHostStatusId()));
                            datas.setSignalStrength(StringUtils.isEmpty(tDetectorReportDataForm.getSignalStrength()) ? null : Integer.parseInt(tDetectorReportDataForm.getSignalStrength()));
                            datas.setNetPoint(StringUtils.isEmpty(tDetectorReportDataForm.getNetPoint()) ? null : Integer.parseInt(tDetectorReportDataForm.getNetPoint()));
                            datas.setIpAddress(StringUtils.isEmpty(tDetectorReportDataForm.getIpAddress()) ? null : tDetectorReportDataForm.getIpAddress());
                            datas.setCreateTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime()) ? null : new Date());
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            datas.setAlarmTime(dateFormat.format(datas.getCreateTime()));
                            tDetectorReportDataService.insertTDetectorReportData(datas);
                            //webSocketServer.batchSendMessage(JSONObject.toJSONString("success"));
//                            TDetectorInfo info = tDetectorInfoService.selectTDetectorInfoByCode(datas.getDetectorCode());
//                            datas.setDetectorType(info.getDetectorType());
                            webSocketServer.batchSendMessage(JSONObject.toJSONString(datas));
                        }
                    }

                    //修改状态
                    updateDevice(tDetectorReportDataForm,deviceUser);
                    //消警处理
                    if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && "1".equals((tDetectorReportDataForm.getDeviceStatusId()))){
//                        ZHDeviceReportDatasExample zhDeviceReportDatasExample = new ZHDeviceReportDatasExample();
//                        zhDeviceReportDatasExample.createCriteria().andDeviceNoEqualTo(tDetectorReportDataForm.getDeviceNo());
//                        zhDeviceReportDatasExample.setOrderByClause(" create_time DESC LIMIT 1");
//
//                        List<ZHDeviceReportDatas> dataList = zHDeviceReportDataService.selectByExample(zhDeviceReportDatasExample);

                        // 查询该设备所有未消警的数据
                        List<TDetectorReportData> dataList = tDetectorReportDataService.selectTDetectorReportDataByCode(tDetectorReportDataForm.getDeviceNo());
                        if(dataList.size() > 0){
                            for(TDetectorReportData data : dataList) {
                                data.setIsCancelAlarm("1"); // 1自动消警
                                data.setCancelTime(StringUtils.isEmpty(tDetectorReportDataForm.getCreateTime()) ? null : new Date());
                                tDetectorReportDataService.updateTDetectorReportData(data);
                            }
                        }

                    }
                //}
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("【新增泽宏设备上报数据】操作出错,error={},zhDeviceReportDataForm={}",e.getMessage(),tDetectorReportDataForm);
            throw new IOCException(ResultEnum.OPERATION_FAIL);
        }

        return AjaxResult.success();
    }
    //修改设备状态
    public void updateDevice(TDetectorReportDataForm tDetectorReportDataForm,TDeviceUser deviceUser){
        //设备状态更新
        if(StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId())||(tDetectorReportDataForm.getDeviceStatusId()).equals(deviceUser.getStatus())){
            return;
        }
        // 探测器 推送数据（1正常，7、9离线，其他值预警）   用电推送数据（E正常，其他都为报警值）用电手动消警 用 E 代表
        if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && "1".equals((tDetectorReportDataForm.getDeviceStatusId()))){
            deviceUser.setStatus(0); // 设备表状态 0正常，1故障（掉线）
            deviceUser.setAlarmTime(null);
            deviceUser.setUpdateTime(new Date());
        }else{
            if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceType()) && tDetectorReportDataForm.getDeviceType().equals("1")){
                if(!StringUtils.isEmpty(tDetectorReportDataForm.getDeviceStatusId()) && new ArrayList<String>(Arrays.asList("7","9")).contains((tDetectorReportDataForm.getDeviceStatusId()))){
                    deviceUser.setStatus(1);
                }else{
                    deviceUser.setStatus(2);
                }
            }
//                        else{
//                            detectorInfo.setDetectorStatus("2");
//                        }
            deviceUser.setAlarmTime(tDetectorReportDataForm.getCreateTime());
            deviceUser.setUpdateTime(new Date());
            itDeviceUserService.updateTDeviceUser(deviceUser);
        }
        return;
    }

}
