package com.zehong.web.controller.specialist;

import java.util.List;

import com.zehong.system.domain.TProAppInforBrowse;
import com.zehong.system.service.ITProAppInforBrowseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.FProBehInfor;
import com.zehong.system.service.IFProBehInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 行业专家库-专家行为申报Controller
 * 
 * @author zehong
 * @date 2024-05-09
 */
@RestController
@RequestMapping("/specialist/behInfo")
public class FProBehInforController extends BaseController
{
    @Autowired
    private IFProBehInforService fProBehInforService;
    @Autowired
    private ITProAppInforBrowseService tProAppInforBrowseService;

    /**
     * 查询行业专家库-专家行为申报列表
     */
    @GetMapping("/list")
    public TableDataInfo list(FProBehInfor fProBehInfor)
    {
        startPage();
        List<FProBehInfor> list = fProBehInforService.selectFProBehInforList(fProBehInfor);
        return getDataTable(list);
    }

    /**
     * 导出行业专家库-专家行为申报列表
     */
    @Log(title = "行业专家库-专家行为申报", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(FProBehInfor fProBehInfor)
    {
        List<FProBehInfor> list = fProBehInforService.selectFProBehInforList(fProBehInfor);
        ExcelUtil<FProBehInfor> util = new ExcelUtil<FProBehInfor>(FProBehInfor.class);
        return util.exportExcel(list, "行业专家库-专家行为申报数据");
    }

    /**
     * 获取行业专家库-专家行为申报详细信息
     */
    @GetMapping(value = "/{fProBehInforId}")
    public AjaxResult getInfo(@PathVariable("fProBehInforId") Long fProBehInforId)
    {
        return AjaxResult.success(fProBehInforService.selectFProBehInforById(fProBehInforId));
    }

    /**
     * 新增行业专家库-专家行为申报
     */
    @Log(title = "行业专家库-专家行为申报", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody FProBehInfor fProBehInfor)
    {
        return toAjax(fProBehInforService.insertFProBehInfor(fProBehInfor));
    }

    /**
     * 修改行业专家库-专家行为申报
     */
    @Log(title = "行业专家库-专家行为申报", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody FProBehInfor fProBehInfor)
    {
        return toAjax(fProBehInforService.updateFProBehInfor(fProBehInfor));
    }

    /**
     * 删除行业专家库-专家行为申报
     */
    @Log(title = "行业专家库-专家行为申报", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fProBehInforIds}")
    public AjaxResult remove(@PathVariable Long[] fProBehInforIds)
    {
        return toAjax(fProBehInforService.deleteFProBehInforByIds(fProBehInforIds));
    }

    /**
     * 行业专家申报
     * @param fProBehInforId 行业专家行为主键
     * @return
     */
    @GetMapping("/reportProBehInfo")
    public AjaxResult reportProBehInfo(Long fProBehInforId){
        try{
            return toAjax(fProBehInforService.reportProBehInfo(fProBehInforId));
        }catch (Exception e){
            logger.error("行业专家申报接口异常=====",e);
            return AjaxResult.error("行业专家申报接口异常");
        }
    }

    /**
     * 获取申报人列表
     */
    @GetMapping("/getUserList")
    public AjaxResult getUserList(){
        List<TProAppInforBrowse> list = tProAppInforBrowseService.selectTProAppInforBrowseList(new TProAppInforBrowse());
        list.stream().forEach(e->e.setfShowName(e.getfName()+"-"+e.getfIdNo()+"-" + ("1".equals(e.getfSex())? "男性": "女性")));
        return AjaxResult.success(list);
    }
}
