package com.zehong.web.controller.risk;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TRiskDevMajInfor;
import com.zehong.system.service.ITRiskDevMajInforService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 重要风险点管控Controller
 * 
 * @author zehong
 * @date 2024-07-01
 */
@RestController
@RequestMapping("/risk/info")
public class TRiskDevMajInforController extends BaseController
{
    @Autowired
    private ITRiskDevMajInforService tRiskDevMajInforService;

    /**
     * 查询重要风险点管控列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TRiskDevMajInfor tRiskDevMajInfor)
    {
        startPage();
        List<TRiskDevMajInfor> list = tRiskDevMajInforService.selectTRiskDevMajInforList(tRiskDevMajInfor);
        return getDataTable(list);
    }

    /**
     * 导出重要风险点管控列表
     */
    @Log(title = "重要风险点管控", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TRiskDevMajInfor tRiskDevMajInfor)
    {
        List<TRiskDevMajInfor> list = tRiskDevMajInforService.exportRiskDevMajInforList(tRiskDevMajInfor);
        ExcelUtil<TRiskDevMajInfor> util = new ExcelUtil<TRiskDevMajInfor>(TRiskDevMajInfor.class);
        AjaxResult ajaxResult = util.exportExcel(list, "重要风险点管控数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取重要风险点管控详细信息
     */
    @GetMapping(value = "/{fRiskDevMajInforId}")
    public AjaxResult getInfo(@PathVariable("fRiskDevMajInforId") Long fRiskDevMajInforId)
    {
        return AjaxResult.success(tRiskDevMajInforService.selectTRiskDevMajInforById(fRiskDevMajInforId));
    }

    /**
     * 获取重要风险点管控详细信息
     */
    @GetMapping(value = "/getInfoForDetail/{fRiskDevMajInforId}")
    public AjaxResult getInfoForDetail(@PathVariable("fRiskDevMajInforId") Long fRiskDevMajInforId)
    {
        return AjaxResult.success(tRiskDevMajInforService.selectTRiskDevMajInforByIdForDetail(fRiskDevMajInforId));
    }
    /**
     * 新增重要风险点管控
     */
    @Log(title = "重要风险点管控", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TRiskDevMajInfor tRiskDevMajInfor)
    {
        return toAjax(tRiskDevMajInforService.insertTRiskDevMajInfor(tRiskDevMajInfor));
    }

    /**
     * 修改重要风险点管控
     */
    @Log(title = "重要风险点管控", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TRiskDevMajInfor tRiskDevMajInfor)
    {
        return toAjax(tRiskDevMajInforService.updateTRiskDevMajInfor(tRiskDevMajInfor));
    }

    /**
     * 删除重要风险点管控
     */
    @Log(title = "重要风险点管控", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fRiskDevMajInforIds}")
    public AjaxResult remove(@PathVariable Long[] fRiskDevMajInforIds)
    {
        return toAjax(tRiskDevMajInforService.deleteTRiskDevMajInforByIds(fRiskDevMajInforIds));
    }

    /**
     * 政府端 上传重要风险点档案
     * @param fRiskDevMajInforId 重要风险点档案id
     * @return
     */
    @GetMapping("/reportRiskInfo")
    public AjaxResult reportRiskInfo(Long fRiskDevMajInforId){
        try{
            return toAjax(tRiskDevMajInforService.reportRiskInfo(fRiskDevMajInforId));
        }catch (Exception e){
            logger.error("上传重要风险点档案接口异常=====",e);
            return AjaxResult.error("上传重要风险点档案接口异常");
        }
    }


    /**
     * 企业端 上传计划和进度
     * @param fRiskDevMajInforId 计划id
     * @return
     */
    @GetMapping("/entReportRiskInfo")
    public AjaxResult entReportRiskInfo(Long fRiskDevMajInforId) {
        return toAjax(tRiskDevMajInforService.entReportRiskInfo(fRiskDevMajInforId));
    }
}
