package com.zehong.web.controller.operationMonitor;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TVehicleLocationInfo;
import com.zehong.system.service.ITVehicleLocationInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 燃气车辆位置信息Controller
 * 
 * @author zehong
 * @date 2022-03-17
 */
@RestController
@RequestMapping("/system/vehicleLocationInfo")
public class TVehicleLocationInfoController extends BaseController
{
    @Autowired
    private ITVehicleLocationInfoService tVehicleLocationInfoService;

    /**
     * 查询燃气车辆位置信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TVehicleLocationInfo tVehicleLocationInfo)
    {
        startPage();
        List<TVehicleLocationInfo> list = tVehicleLocationInfoService.selectTVehicleLocationInfoList(tVehicleLocationInfo);
        return getDataTable(list);
    }

    /**
     * 获取车辆位置信息
     * @param tVehicleLocationInfo
     * @return
     */
    @GetMapping("/getVehicleLocations")
    public AjaxResult getVehicleLocations(TVehicleLocationInfo tVehicleLocationInfo){
        return AjaxResult.success( tVehicleLocationInfoService.selectTVehicleLocationInfoList(tVehicleLocationInfo));
    }

    /**
     * 导出燃气车辆位置信息列表
     */
    @Log(title = "燃气车辆位置信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVehicleLocationInfo tVehicleLocationInfo)
    {
        List<TVehicleLocationInfo> list = tVehicleLocationInfoService.selectTVehicleLocationInfoList(tVehicleLocationInfo);
        ExcelUtil<TVehicleLocationInfo> util = new ExcelUtil<TVehicleLocationInfo>(TVehicleLocationInfo.class);
        return util.exportExcel(list, "燃气车辆位置信息数据");
    }

    /**
     * 获取燃气车辆位置信息详细信息
     */
    @GetMapping(value = "/{vehicleLocationId}")
    public AjaxResult getInfo(@PathVariable("vehicleLocationId") Long vehicleLocationId)
    {
        return AjaxResult.success(tVehicleLocationInfoService.selectTVehicleLocationInfoById(vehicleLocationId));
    }

    /**
     * 新增燃气车辆位置信息
     */
    @Log(title = "燃气车辆位置信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVehicleLocationInfo tVehicleLocationInfo)
    {
        return toAjax(tVehicleLocationInfoService.insertTVehicleLocationInfo(tVehicleLocationInfo));
    }

    /**
     * 修改燃气车辆位置信息
     */
    @Log(title = "燃气车辆位置信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVehicleLocationInfo tVehicleLocationInfo)
    {
        return toAjax(tVehicleLocationInfoService.updateTVehicleLocationInfo(tVehicleLocationInfo));
    }

    /**
     * 删除燃气车辆位置信息
     */
    @Log(title = "燃气车辆位置信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{vehicleLocationIds}")
    public AjaxResult remove(@PathVariable Long[] vehicleLocationIds)
    {
        return toAjax(tVehicleLocationInfoService.deleteTVehicleLocationInfoByIds(vehicleLocationIds));
    }
}
