package com.zehong.web.controller.operationMonitor;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.service.ITDeviceReportDataService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备监控Controller
 * 
 * @author zehong
 * @date 2022-02-16
 */
@RestController
@RequestMapping("/system/data")
public class TDeviceReportDataController extends BaseController
{
    @Autowired
    private ITDeviceReportDataService tDeviceReportDataService;

    /**
     * 查询设备监控列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDeviceReportData tDeviceReportData)
    {
        startPage();
        List<TDeviceReportData> list = tDeviceReportDataService.selectTDeviceReportDataList(tDeviceReportData);
        return getDataTable(list);
    }

    /**
     * 导出设备监控列表
     */
    @Log(title = "设备监控", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceReportData tDeviceReportData)
    {
        List<TDeviceReportData> list = tDeviceReportDataService.selectTDeviceReportDataList(tDeviceReportData);
        ExcelUtil<TDeviceReportData> util = new ExcelUtil<TDeviceReportData>(TDeviceReportData.class);
        return util.exportExcel(list, "设备监控数据");
    }

    /**
     * 获取设备监控详细信息
     */
    @GetMapping(value = "/{deviceReportDataId}")
    public AjaxResult getInfo(@PathVariable("deviceReportDataId") Long deviceReportDataId)
    {
        return AjaxResult.success(tDeviceReportDataService.selectTDeviceReportDataById(deviceReportDataId));
    }

    /**
     * 新增设备监控
     */
    @Log(title = "设备监控", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceReportData tDeviceReportData)
    {
        return toAjax(tDeviceReportDataService.insertTDeviceReportData(tDeviceReportData));
    }

    /**
     * 修改设备监控
     */
    @Log(title = "设备监控", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceReportData tDeviceReportData)
    {
        return toAjax(tDeviceReportDataService.updateTDeviceReportData(tDeviceReportData));
    }

    /**
     * 删除设备监控
     */
    @Log(title = "设备监控", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deviceReportDataIds}")
    public AjaxResult remove(@PathVariable Long[] deviceReportDataIds)
    {
        return toAjax(tDeviceReportDataService.deleteTDeviceReportDataByIds(deviceReportDataIds));
    }
}
