package com.zehong.web.controller.lpgRegulation;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TYehuaqiuserSafetyDeviceInfo;
import com.zehong.system.service.ITYehuaqiuserSafetyDeviceInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 液化石油气监管-液化气用户-安全装置加装维护Controller
 * 
 * @author zehong
 * @date 2024-09-09
 */
@RestController
@RequestMapping("/yehuaqiUserSafetyDeviceInfo/info")
public class TYehuaqiuserSafetyDeviceInfoController extends BaseController
{
    @Autowired
    private ITYehuaqiuserSafetyDeviceInfoService tYehuaqiuserSafetyDeviceInfoService;

    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        startPage();
        List<TYehuaqiuserSafetyDeviceInfo> list = tYehuaqiuserSafetyDeviceInfoService.selectTYehuaqiuserSafetyDeviceInfoList(tYehuaqiuserSafetyDeviceInfo);
        return getDataTable(list);
    }


    /**
     * 根据 燃气用户id 查询集合数据
     * @param userId i
     */
    @GetMapping("/queryDeviceInfoByUserId/{userId}")
    public AjaxResult queryDeviceInfoByUserId(@PathVariable("userId") Long userId){
        return AjaxResult.success(tYehuaqiuserSafetyDeviceInfoService.queryDeviceInfoByUserId(userId));
    }


    /**
     * 导出液化石油气监管-液化气用户-安全装置加装维护列表
     */
    @Log(title = "液化石油气监管-液化气用户-安全装置加装维护", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        List<TYehuaqiuserSafetyDeviceInfo> list = tYehuaqiuserSafetyDeviceInfoService.selectTYehuaqiuserSafetyDeviceInfoList(tYehuaqiuserSafetyDeviceInfo);
        ExcelUtil<TYehuaqiuserSafetyDeviceInfo> util = new ExcelUtil<TYehuaqiuserSafetyDeviceInfo>(TYehuaqiuserSafetyDeviceInfo.class);
        return util.exportExcel(list, "液化石油气监管-液化气用户-安全装置加装维护数据");
    }

    /**
     * 获取液化石油气监管-液化气用户-安全装置加装维护详细信息
     */
    @GetMapping(value = "/{fSafetyDeviceId}")
    public AjaxResult getInfo(@PathVariable("fSafetyDeviceId") Long fSafetyDeviceId)
    {
        return AjaxResult.success(tYehuaqiuserSafetyDeviceInfoService.selectTYehuaqiuserSafetyDeviceInfoById(fSafetyDeviceId));
    }

    /**
     * 新增液化石油气监管-液化气用户-安全装置加装维护
     */
    @Log(title = "液化石油气监管-液化气用户-安全装置加装维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        return toAjax(tYehuaqiuserSafetyDeviceInfoService.insertTYehuaqiuserSafetyDeviceInfo(tYehuaqiuserSafetyDeviceInfo));
    }

    /**
     * 修改液化石油气监管-液化气用户-安全装置加装维护
     */
    @Log(title = "液化石油气监管-液化气用户-安全装置加装维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        return toAjax(tYehuaqiuserSafetyDeviceInfoService.updateTYehuaqiuserSafetyDeviceInfo(tYehuaqiuserSafetyDeviceInfo));
    }

    /**
     * 删除液化石油气监管-液化气用户-安全装置加装维护
     */
    @Log(title = "液化石油气监管-液化气用户-安全装置加装维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fSafetyDeviceIds}")
    public AjaxResult remove(@PathVariable Long[] fSafetyDeviceIds)
    {
        return toAjax(tYehuaqiuserSafetyDeviceInfoService.deleteTYehuaqiuserSafetyDeviceInfoByIds(fSafetyDeviceIds));
    }

    /**
     * 删除液化石油气监管-液化气用户-安全装置加装维护-单个删除
     */
    @Log(title = "液化石油气监管-液化气用户-安全装置加装维护", businessType = BusinessType.DELETE)
    @DeleteMapping("/deleteTYehuaqiuserSafetyDeviceInfoById/{fSafetyDeviceId}")
    public AjaxResult deleteTYehuaqiuserSafetyDeviceInfoById(@PathVariable Long fSafetyDeviceId) {
        return toAjax(tYehuaqiuserSafetyDeviceInfoService.deleteTYehuaqiuserSafetyDeviceInfoById(fSafetyDeviceId));
    }
}
