package com.zehong.web.controller.lpgRegulation;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TLpgVehicleInfo;
import com.zehong.system.service.ITLpgVehicleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;

/**
 * 液化石油车辆信息Controller
 * 
 * @author zehong
 * @date 2024-07-19
 */
@RestController
@RequestMapping("/lpg/vehicleInfo")
public class TLpgVehicleInfoController extends BaseController
{
    @Autowired
    private ITLpgVehicleInfoService tLpgVehicleInfoService;

    /**
     * 查询液化石油车辆信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLpgVehicleInfo tLpgVehicleInfo)
    {
        startPage();
        List<TLpgVehicleInfo> list = tLpgVehicleInfoService.selectTLpgVehicleInfoList(tLpgVehicleInfo);
        return getDataTable(list);
    }

    /**
     * 导出液化石油车辆信息列表
     */
    @Log(title = "液化石油车辆信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLpgVehicleInfo tLpgVehicleInfo)
    {
        List<TLpgVehicleInfo> list = tLpgVehicleInfoService.selectTLpgVehicleInfoList(tLpgVehicleInfo);
        ExcelUtil<TLpgVehicleInfo> util = new ExcelUtil<TLpgVehicleInfo>(TLpgVehicleInfo.class);
        return util.exportExcel(list, "液化石油车辆信息数据");
    }

    /**
     * 获取液化石油车辆信息详细信息
     */
    @GetMapping(value = "/{vehicleId}")
    public AjaxResult getInfo(@PathVariable("vehicleId") Long vehicleId)
    {
        return AjaxResult.success(tLpgVehicleInfoService.selectTLpgVehicleInfoById(vehicleId));
    }

    /**
     * 新增液化石油车辆信息
     */
    @Log(title = "液化石油车辆信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLpgVehicleInfo tLpgVehicleInfo)
    {
        return toAjax(tLpgVehicleInfoService.insertTLpgVehicleInfo(tLpgVehicleInfo));
    }

    /**
     * 修改液化石油车辆信息
     */
    @Log(title = "液化石油车辆信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLpgVehicleInfo tLpgVehicleInfo)
    {
        return toAjax(tLpgVehicleInfoService.updateTLpgVehicleInfo(tLpgVehicleInfo));
    }

    /**
     * 删除液化石油车辆信息
     */
    @Log(title = "液化石油车辆信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{vehicleIds}")
    public AjaxResult remove(@PathVariable Long[] vehicleIds)
    {
        return toAjax(tLpgVehicleInfoService.deleteTLpgVehicleInfoByIds(vehicleIds));
    }

    /**
     * 模版下载
     * @return r
     */
    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TLpgVehicleInfo> util = new ExcelUtil<>(TLpgVehicleInfo.class);
        return util.importTemplateExcel("车辆信息数据");
    }

    /**
     * 文件导入
     * @param file f
     * @param updateSupport u
     * @return r
     * @throws Exception r
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport, HttpServletResponse response) throws Exception
    {

        ExcelUtil<TLpgVehicleInfo> util = new ExcelUtil<>(TLpgVehicleInfo.class);
        List<TLpgVehicleInfo> XmbhList = util.importExcel(file.getInputStream());

        return tLpgVehicleInfoService.importLpgSafeCheckRecordInfo(XmbhList, updateSupport, response);
    }

}
