package com.zehong.web.controller.lpgRegulation;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.vo.TLpgDeliveryRecordImportVo;
import com.zehong.system.domain.vo.TLpgSafeCheckRecordImportVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TLpgSafeCheckRecord;
import com.zehong.system.service.ITLpgSafeCheckRecordService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油安检记录Controller
 * 
 * @author zehong
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/lpg/check")
public class TLpgSafeCheckRecordController extends BaseController
{
    @Autowired
    private ITLpgSafeCheckRecordService tLpgSafeCheckRecordService;

    /**
     * 查询液化石油安检记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        startPage();
        List<TLpgSafeCheckRecord> list = tLpgSafeCheckRecordService.selectTLpgSafeCheckRecordList(tLpgSafeCheckRecord);
        return getDataTable(list);
    }

    /**
     * 导出液化石油安检记录列表
     */
    @Log(title = "液化石油安检记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        List<TLpgSafeCheckRecord> list = tLpgSafeCheckRecordService.selectTLpgSafeCheckRecordList(tLpgSafeCheckRecord);
        ExcelUtil<TLpgSafeCheckRecord> util = new ExcelUtil<TLpgSafeCheckRecord>(TLpgSafeCheckRecord.class);
        return util.exportExcel(list, "液化石油安检记录数据");
    }

    /**
     * 获取液化石油安检记录详细信息
     */
    @GetMapping(value = "/{safeCheckId}")
    public AjaxResult getInfo(@PathVariable("safeCheckId") Long safeCheckId)
    {
        return AjaxResult.success(tLpgSafeCheckRecordService.selectTLpgSafeCheckRecordById(safeCheckId));
    }

    /**
     * 新增液化石油安检记录
     */
    @Log(title = "液化石油安检记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        return toAjax(tLpgSafeCheckRecordService.insertTLpgSafeCheckRecord(tLpgSafeCheckRecord));
    }

    /**
     * 修改液化石油安检记录
     */
    @Log(title = "液化石油安检记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        return toAjax(tLpgSafeCheckRecordService.updateTLpgSafeCheckRecord(tLpgSafeCheckRecord));
    }

    /**
     * 删除液化石油安检记录
     */
    @Log(title = "液化石油安检记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{safeCheckIds}")
    public AjaxResult remove(@PathVariable Long[] safeCheckIds)
    {
        return toAjax(tLpgSafeCheckRecordService.deleteTLpgSafeCheckRecordByIds(safeCheckIds));
    }


    /**
     * 模版下载
     * @return r
     */
    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TLpgSafeCheckRecordImportVo> util = new ExcelUtil<>(TLpgSafeCheckRecordImportVo.class);
        return util.importTemplateExcel("安检记录数据");
    }

    /**
     * 文件导入- 只支持 企业端导入
     * @param file f
     * @param updateSupport u
     * @return r
     * @throws Exception r
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport, HttpServletResponse response) throws Exception
    {

        if(!isEnterprise()) {
            return AjaxResult.error("只支持 企业端导入！！！");
        }

        ExcelUtil<TLpgSafeCheckRecordImportVo> util = new ExcelUtil<>(TLpgSafeCheckRecordImportVo.class);
        List<TLpgSafeCheckRecordImportVo> XmbhList = util.importExcel(file.getInputStream());

        String deptId = SecurityUtils.getLoginUser().getUser().getDeptId();
        HashMap<String, Object> map = tLpgSafeCheckRecordService.importLpgSafeCheckRecordInfo(XmbhList, updateSupport, deptId, response);
        return AjaxResult.success(map);
    }


    /**
     * 判断是否为企业
     * @return r
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }



}
