package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TGasUserInfo;
import com.zehong.system.domain.TGasUserInfolins;
import com.zehong.system.domain.TTaskRecord;
import com.zehong.system.service.ITGasUserInfoService;
import com.zehong.system.service.ITTaskRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 燃气用户Controller
 *
 * @author zehong
 * @date 2023-08-17
 */
@RestController
@RequestMapping("/gasUser/info")
public class TGasUserInfoController extends BaseController
{
    @Autowired
    private ITGasUserInfoService tGasUserInfoService;

    @Autowired
    private ITTaskRecordService tTaskRecordService;
    /**
     * 查询燃气用户列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TGasUserInfo tGasUserInfo)
    {
        startPage();
        List<TGasUserInfo> list = tGasUserInfoService.selectTGasUserInfoList(tGasUserInfo);
        return getDataTable(list);
    }

    /**
     * 微信小程序 获取燃气用户详细信息
     * @param gasUserId
     * @return
     */
    @GetMapping("/selectGet")
    public AjaxResult selectGetInfo(Long gasUserId){
        TGasUserInfo tGasUserInfo = tGasUserInfoService.selectTGasUserInfoById(gasUserId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasUserInfo", tGasUserInfo);
        return ajax;
    }

    @GetMapping("/gasUserInfoList")
    public AjaxResult gasUserInfoList(TGasUserInfo tGasUserInfo){
        List<TGasUserInfo> list = tGasUserInfoService.selectTGasUserInfoList(tGasUserInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出燃气用户列表
     */
    @Log(title = "燃气用户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGasUserInfo tGasUserInfo)
    {
        List<TGasUserInfo> list = tGasUserInfoService.selectTGasUserInfoList(tGasUserInfo);
        ExcelUtil<TGasUserInfo> util = new ExcelUtil<TGasUserInfo>(TGasUserInfo.class);
        return util.exportExcel(list, "燃气用户数据");
    }

    /**
     * 获取燃气用户详细信息
     */
    @GetMapping(value = "/{gasUserId}")
    public AjaxResult getInfo(@PathVariable("gasUserId") Long gasUserId)
    {
        return AjaxResult.success(tGasUserInfoService.selectTGasUserInfoById(gasUserId));
    }

    @PostMapping("/getUser")
    public AjaxResult getUser(@RequestBody  TGasUserInfo tGasUserInfo)
    {
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasUserInfon", tGasUserInfoService.selectTGasUserInfoById(tGasUserInfo.getGasUserId()));
        return ajax;
    }


    /**
     * 微信小程序下拉信息查询
     * @param tGasUserInfo
     * @return
     */
    @PostMapping("/gasUserId")
    public AjaxResult gasUserId(@RequestBody TGasUserInfo tGasUserInfo)
    {
        TGasUserInfo tGasUserInfo1 = tGasUserInfoService.selectTGasUserInfoById(tGasUserInfo.getGasUserId());
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasUserInfon", tGasUserInfo1);
        return ajax;
    }

    /**
     * 小程序 查询燃气用户信息
     * @param tGasUserInfo
     * @return
     */
    @PostMapping("/gasUser")
    public AjaxResult gasUser(@RequestBody TGasUserInfo tGasUserInfo)
    {
        List<TGasUserInfo> tGasUserInfos = tGasUserInfoService.gasUser(tGasUserInfo);
        List list=new ArrayList();
        for (int i=0;i<tGasUserInfos.size();i++){
            TGasUserInfolins tGasUserInfolins=new TGasUserInfolins();
            tGasUserInfolins.setLabel(tGasUserInfos.get(i).getGasUserName());
            tGasUserInfolins.setValue(String.valueOf(tGasUserInfos.get(i).getGasUserId()));
            list.add(tGasUserInfolins);
        }
        AjaxResult ajax = AjaxResult.success();
        ajax.put("list", list);
        ajax.put("tGasBottleInfo", tGasUserInfos);
        return ajax;
    }
    /**
     * 新增燃气用户
     */
    @Log(title = "燃气用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasUserInfo tGasUserInfo)
    {
        return toAjax(tGasUserInfoService.insertTGasUserInfo(tGasUserInfo));
    }

    /**
     * 微信小程序新增燃气用户
     * @param tGasUserInfo
     * @return
     */
    @PostMapping("/addUserInfo")
    public AjaxResult addUserInfo(@RequestBody TGasUserInfo tGasUserInfo){
        tGasUserInfoService.insertTGasUserInfo(tGasUserInfo);
        //设置任务记录信息
        TTaskRecord tTaskRecord=new TTaskRecord();
        //操作人id
        tTaskRecord.setOperator(Long.valueOf(tGasUserInfo.getOperator()));
        //工序
        tTaskRecord.setProcessesName("5");
        tTaskRecord.setCreateTime(new Date());
        tTaskRecord.setProcessesRelationId(tGasUserInfo.getGasUserId());
        //任务记录表信息添加
        return toAjax(tTaskRecordService.insertTTaskRecord(tTaskRecord));
    }


    /**
     * 微信小程序修改燃气用户
     * @param tGasUserInfo
     * @return
     */
    @PostMapping("/updateUserInfo")
    public AjaxResult updateUserInfo(@RequestBody TGasUserInfo tGasUserInfo)
    {
        return toAjax(tGasUserInfoService.updateTGasUserInfo(tGasUserInfo));
    }


    /**
     * 修改燃气用户
     */
    @Log(title = "燃气用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasUserInfo tGasUserInfo)
    {
        return toAjax(tGasUserInfoService.updateTGasUserInfo(tGasUserInfo));
    }


    /**
     * 删除燃气用户
     */
    @Log(title = "燃气用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{gasUserIds}")
    public AjaxResult remove(@PathVariable Long[] gasUserIds)
    {
        return toAjax(tGasUserInfoService.deleteTGasUserInfoByIds(gasUserIds));
    }

    /**
     * 燃气用户导入
     * @param file
     * @param updateSupport
     * @return
     * @throws Exception
     */
    @Log(title = "燃气用户导入", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<TGasUserInfo> util = new ExcelUtil<>(TGasUserInfo.class);
        List<TGasUserInfo> tGasUserInfoList = util.importExcel(file.getInputStream());
        String message = tGasUserInfoService.importTGasUserInfo(tGasUserInfoList, updateSupport);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TGasUserInfo> util = new ExcelUtil<>(TGasUserInfo.class);
        return util.importTemplateExcel("燃气用户数据");
    }
}
